/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.registrar;

import dev.xylonity.knightlib.api.registrar.ResourceEntry;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public interface ResourceRegistry<T> {
    public <I extends T> ResourceEntry<I> register(String var1, Supplier<? extends I> var2);

    default public <X extends Entity> ResourceEntry<EntityType<X>> registerEntity(String name, EntityType.EntityFactory<X> entity, MobCategory category, float width, float height, @Nullable List<Consumer<EntityType.Builder<X>>> properties) {
        return this.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)category).m_20699_(width, height);
            if (properties != null) {
                for (Consumer property : properties) {
                    property.accept(builder);
                }
            }
            return builder.m_20712_(new ResourceLocation(this.getNamespace(), name).toString());
        });
    }

    default public <X extends Entity> ResourceEntry<EntityType<X>> registerEntity(String name, EntityType.EntityFactory<X> entity, MobCategory category, float width, float height) {
        return this.registerEntity(name, entity, category, width, height, null);
    }

    public Collection<ResourceEntry<T>> getEntries();

    default public Stream<T> stream() {
        return this.getEntries().stream().map(ResourceEntry::get);
    }

    public String getNamespace();

    public void init();
}

