/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.bossbar;

import dev.xylonity.knightlib.api.bossbar.BossBarContext;
import dev.xylonity.knightlib.impl.internal.BossBarApi;
import dev.xylonity.knightlib.impl.internal.CustomBossBarRenderer;
import dev.xylonity.knightlib.impl.internal.LegacyCustomBossBarRenderer;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.LerpingBossEvent;

public final class BossBarBuilder {
    private Predicate<LerpingBossEvent> legacyMatcher;
    private Predicate<BossBarContext> matcher;
    private LegacyCustomBossBarRenderer legacyRenderer;
    private CustomBossBarRenderer renderer;
    private int padding = 0;
    private boolean hideName = false;

    public static BossBarBuilder legacyMatcher(Predicate<LerpingBossEvent> matcher) {
        BossBarBuilder builder = new BossBarBuilder();
        builder.legacyMatcher = matcher;
        return builder;
    }

    public static BossBarBuilder matcher(Predicate<BossBarContext> matcher) {
        BossBarBuilder builder = new BossBarBuilder();
        builder.matcher = matcher;
        return builder;
    }

    public BossBarBuilder legacyRenderer(LegacyCustomBossBarRenderer renderer) {
        this.legacyRenderer = renderer;
        return this;
    }

    public BossBarBuilder renderer(CustomBossBarRenderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public BossBarBuilder padding(int padding) {
        this.padding = padding;
        return this;
    }

    public BossBarBuilder hideVanillaName() {
        this.hideName = true;
        return this;
    }

    public void register() {
        BossBarApi.register(new BossBarApi.BossBarEntry(this.legacyMatcher, this.matcher, this.legacyRenderer, this.renderer, this.padding, this.hideName));
    }
}

