/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class REIIntegration
implements REIClientPlugin {
    public static final ResourceLocation ID = new ResourceLocation("ftblibrary", "sidebar_button");
    private static final ResourceSearchMode<ItemStack> REI_ITEMS = new ResourceSearchMode<ItemStack>(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_151079_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.rei");
        }

        @Override
        public Collection<? extends SelectableResource<ItemStack>> getAllResources() {
            return CollectionUtils.filterAndMap((Iterable)EntryRegistry.getInstance().getPreFilteredList(), stack -> stack.getType().equals((Object)VanillaEntryTypes.ITEM), stack -> (SelectableResource)stack.castValue());
        }
    };

    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(ID, (FavoriteEntryType)SidebarButtonType.INSTANCE);
        for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.getGroups()) {
            List buttons = CollectionUtils.map(group.getButtons(), SidebarButtonEntry::new);
            if (buttons.isEmpty()) continue;
            registry.getOrCrateSection((Component)Component.m_237115_((String)group.getLangKey())).add(group.isPinned(), (FavoriteEntry[])buttons.toArray(new SidebarButtonEntry[0]));
        }
    }

    private static SidebarButton createSidebarButton(ResourceLocation id, SidebarButtonGroup g, JsonObject json) {
        SidebarButton b = new SidebarButton(id, g, json);
        ((Consumer)SidebarButtonCreatedEvent.EVENT.invoker()).accept(new SidebarButtonCreatedEvent(b));
        return b;
    }

    static {
        SelectItemStackScreen.KNOWN_MODES.prependMode(REI_ITEMS);
    }

    private static enum SidebarButtonType implements FavoriteEntryType<SidebarButtonEntry>
    {
        INSTANCE;


        public CompoundTag save(SidebarButtonEntry entry, CompoundTag tag) {
            tag.m_128359_("id", entry.button.getId().toString());
            tag.m_128359_("json", new Gson().toJson((JsonElement)entry.button.getJson()));
            return tag;
        }

        public DataResult<SidebarButtonEntry> read(CompoundTag object) {
            ResourceLocation id = new ResourceLocation(object.m_128461_("id"));
            JsonObject json = (JsonObject)JsonParser.parseString((String)object.m_128461_("json"));
            return DataResult.success((Object)((Object)new SidebarButtonEntry(REIIntegration.createSidebarButton(id, null, json))), (Lifecycle)Lifecycle.stable());
        }

        public DataResult<SidebarButtonEntry> fromArgs(Object ... args) {
            SidebarButton button;
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create SidebarButtonEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof ResourceLocation)) {
                return DataResult.error(() -> "Creation of SidebarButtonEntry from args expected ResourceLocation as the first argument!");
            }
            ResourceLocation id = (ResourceLocation)object;
            if (!(args[1] instanceof SidebarButton) && !(args[1] instanceof JsonObject)) {
                return DataResult.error(() -> "Creation of SidebarButtonEntry from args expected SidebarButton or JsonObject as the second argument!");
            }
            Object object2 = args[1];
            return DataResult.success((Object)((Object)new SidebarButtonEntry(object2 instanceof SidebarButton ? (button = (SidebarButton)object2) : REIIntegration.createSidebarButton(id, null, (JsonObject)args[1]))), (Lifecycle)Lifecycle.stable());
        }
    }

    private static class SidebarButtonEntry
    extends FavoriteEntry {
        private final SidebarButton button;

        public SidebarButtonEntry(SidebarButton button) {
            this.button = button;
        }

        public boolean isInvalid() {
            for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.getGroups()) {
                for (SidebarButton groupButton : group.getButtons()) {
                    if (!groupButton.getId().equals((Object)this.button.getId()) || !groupButton.isActuallyVisible()) continue;
                    return false;
                }
            }
            return true;
        }

        public Renderer getRenderer(boolean showcase) {
            return new Renderer(){

                public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    GuiHelper.setupDrawing();
                    button.getIcon().draw(graphics, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                    if (button.getCustomTextHandler() != null) {
                        String text = button.getCustomTextHandler().get();
                        Font font = Minecraft.m_91087_().f_91062_;
                        if (!text.isEmpty()) {
                            int width = font.m_92895_(text);
                            int n = bounds.getX() + bounds.getWidth() - width;
                            int n2 = bounds.getY() - 1;
                            Objects.requireNonNull(font);
                            Color4I.LIGHT_RED.draw(graphics, n, n2, width + 1, 9);
                            graphics.m_280488_(font, text, bounds.getX() + bounds.getWidth() - width + 1, bounds.getY(), -1);
                        }
                    }
                }

                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(I18n.m_118938_((String)button.getLangKey(), (Object[])new Object[0]));
                    if (button.getTooltipHandler() != null) {
                        button.getTooltipHandler().accept(list);
                    }
                    return Tooltip.create((Point)context.getPoint(), (Collection)CollectionUtils.map(list, Component::m_237113_));
                }
            };
        }

        public boolean doAction(int button) {
            this.button.onClicked(Screen.m_96638_());
            return true;
        }

        public long hashIgnoreAmount() {
            return this.button.getId().hashCode();
        }

        public FavoriteEntry copy() {
            return new SidebarButtonEntry(REIIntegration.createSidebarButton(this.button.getId(), null, this.button.getJson()));
        }

        public ResourceLocation getType() {
            return ID;
        }

        public boolean isSame(FavoriteEntry other) {
            if (other instanceof SidebarButtonEntry) {
                SidebarButtonEntry entry = (SidebarButtonEntry)other;
                return entry.button.getId().equals((Object)this.button.getId());
            }
            return false;
        }
    }
}

