/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.handler;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.cobweb.api.item.TierUtils;
import it.crystalnest.harvest_with_ease.Constants;
import it.crystalnest.harvest_with_ease.api.HarvestUtils;
import it.crystalnest.harvest_with_ease.api.event.HarvestEvent;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import it.crystalnest.harvest_with_ease.platform.Services;
import java.math.BigDecimal;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.Nullable;

public abstract class HarvestHandler {
    protected HarvestHandler() {
    }

    protected static void handle(LevelAccessor level, BlockState crop, BlockPos pos) {
        try {
            if (!level.m_5776_() && ModConfig.getGrantedExp() > 0 && HarvestUtils.isCrop(crop.m_60734_()) && HarvestUtils.isAllowed(crop) && HarvestUtils.isMature(crop) && ((ServerLevel)level).m_46469_().m_46207_(GameRules.f_46136_)) {
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)level), (Vec3)Vec3.m_82512_((Vec3i)pos), (int)ModConfig.getGrantedExp());
            }
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            HarvestHandler.logError(e, pos);
        }
    }

    protected static boolean handle(Level level, BlockState crop, Direction face, BlockPos pos, BlockHitResult hitResult, Player player, InteractionHand hand) {
        boolean consume = false;
        if (hand != null && hand == HarvestHandler.getValidHand(player) && HarvestHandler.canHarvest(level, crop, pos, face, hitResult, player, hand)) {
            try {
                IntegerProperty age = HarvestUtils.getAge(crop);
                if (HarvestUtils.isMature(crop, age)) {
                    consume = true;
                    if (!level.f_46443_) {
                        TieredItem tool;
                        HarvestHandler.harvest((ServerLevel)level, age, crop, pos, pos, face, hitResult, (ServerPlayer)player, hand);
                        Item item = player.m_21120_(hand).m_41720_();
                        if (item instanceof TieredItem && Services.HARVEST.isHoe((tool = (TieredItem)item).m_7968_()) && HarvestUtils.isTierForMultiHarvest(tool)) {
                            int fromCenterToEdge = ((TierUtils.getLevel((Tier)tool.m_43314_()) - TierUtils.getLevel((String)ModConfig.getMultiHarvestStartingTier())) * ModConfig.getAreaIncrementStep().step + ModConfig.getAreaStartingSize().size - 1) / 2;
                            StreamSupport.stream(BlockPos.m_121935_((BlockPos)pos, (int)fromCenterToEdge, (Direction)player.m_6350_(), (Direction)player.m_6350_().m_122427_()).spliterator(), false).filter(cropPos -> !pos.equals(cropPos) && HarvestHandler.canHarvest(level, level.m_8055_((BlockPos)cropPos), (BlockPos)cropPos, face, null, player, hand) && HarvestUtils.isMature(level.m_8055_((BlockPos)cropPos))).forEach(cropPos -> HarvestHandler.harvest((ServerLevel)level, HarvestUtils.getAge(level.m_8055_((BlockPos)cropPos)), level.m_8055_((BlockPos)cropPos), (BlockPos)cropPos, pos, face, null, (ServerPlayer)player, hand));
                        }
                    }
                }
            }
            catch (ClassCastException | NullPointerException | NoSuchElementException e) {
                HarvestHandler.logError(e, pos);
            }
        }
        return consume;
    }

    private static void harvest(ServerLevel level, IntegerProperty age, BlockState crop, BlockPos pos, BlockPos originalPos, Direction face, BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
        Services.EVENT.fireBeforeHarvestEvent(level, crop, pos, face, hitResult, player, hand);
        BlockPos basePos = HarvestHandler.getBasePos(level, crop.m_60734_(), pos);
        HarvestHandler.grantExp(level, basePos);
        HarvestHandler.damageHoe(player, hand);
        HarvestHandler.updateCrop(level, age, crop.m_60734_(), basePos, player, HarvestHandler.dropResources(level, level.m_8055_(basePos), basePos, originalPos, face, hitResult, player, hand));
        HarvestHandler.playSound(level, player, crop, pos);
        HarvestHandler.exhaustPlayer((Player)player);
        Services.EVENT.fireAfterHarvestEvent(level, crop, pos, face, hitResult, player, hand);
    }

    private static void updateCrop(ServerLevel level, IntegerProperty age, Block crop, BlockPos basePos, ServerPlayer player, boolean customDrops) {
        if (crop == Blocks.f_276665_) {
            int i = player.m_150109_().m_36030_(crop.m_7397_((BlockGetter)level, basePos, level.m_8055_(basePos)));
            if (i >= 0 || player.m_7500_()) {
                level.m_46597_(basePos, (BlockState)level.m_8055_(basePos).m_61124_((Property)age, (Comparable)Integer.valueOf(0)));
                if (!player.m_7500_()) {
                    player.m_150109_().m_8020_(i).m_41774_(1);
                }
            } else {
                level.m_46953_(basePos, !customDrops, (Entity)player);
            }
        } else {
            level.m_46597_(basePos, (BlockState)level.m_8055_(basePos).m_61124_((Property)age, (Comparable)Integer.valueOf(0)));
        }
        if (level.m_8055_(basePos).m_204336_(BlockTags.f_13073_) && level.m_8055_(basePos.m_7494_()).m_60713_(crop) && !HarvestHandler.isTallButSeparate(crop)) {
            level.m_46953_(basePos.m_7494_(), !customDrops, (Entity)player);
        }
    }

    private static BlockPos getBasePos(ServerLevel level, Block crop, BlockPos pos) {
        BlockPos basePos = pos;
        while (level.m_8055_(pos).m_204336_(BlockTags.f_13073_) && !HarvestHandler.isTallButSeparate(crop) && level.m_8055_(basePos.m_7495_()).m_60713_(crop)) {
            basePos = basePos.m_7495_();
        }
        return basePos;
    }

    private static void grantExp(ServerLevel level, BlockPos pos) {
        if (ModConfig.getGrantedExp() > 0 && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)Vec3.m_82512_((Vec3i)pos), (int)ModConfig.getGrantedExp());
        }
    }

    private static void damageHoe(ServerPlayer player, InteractionHand hand) {
        if (ModConfig.getRequireHoe().booleanValue() && ModConfig.getDamageOnHarvest() > 0 && !player.m_7500_()) {
            player.m_21120_(hand).m_41622_(ModConfig.getDamageOnHarvest().intValue(), (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
        }
    }

    private static boolean dropResources(ServerLevel level, BlockState crop, BlockPos pos, BlockPos originalPos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
        if (level.m_46469_().m_46207_(GameRules.f_46136_)) {
            HarvestEvent.HarvestDropsEvent event = Services.EVENT.fireHarvestDropsEvent(level, crop, pos, face, hitResult, player, hand);
            HarvestHandler.dropStacks(level, ModConfig.getGatherDrops() != false ? originalPos : pos, face, event.getDrops());
            return event.didDropsChange();
        }
        return false;
    }

    private static void playSound(ServerLevel level, ServerPlayer player, BlockState crop, BlockPos pos) {
        SoundType soundType = Services.HARVEST.getSoundType(level, player, crop, pos);
        level.m_5594_(null, pos, soundType.m_56775_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
    }

    private static void exhaustPlayer(Player player) {
        if (ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) > 0) {
            player.m_36399_(0.005f * ModConfig.getExhaustionMultiplier().floatValue());
        }
    }

    @Nullable
    private static InteractionHand getValidHand(Player player) {
        if (!player.m_6047_()) {
            if (Services.HARVEST.isHoe(player.m_21205_())) {
                return InteractionHand.MAIN_HAND;
            }
            if (Services.HARVEST.isHoe(player.m_21206_())) {
                return InteractionHand.OFF_HAND;
            }
            if (!ModConfig.getRequireHoe().booleanValue()) {
                return InteractionHand.MAIN_HAND;
            }
        }
        return null;
    }

    private static boolean canHarvest(Level level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, Player player, InteractionHand hand) {
        return HarvestUtils.isCrop(crop.m_60734_()) && player.m_36298_(crop) && HarvestUtils.hasEnoughHunger(player) && HarvestUtils.isAllowed(crop) && Services.EVENT.fireHarvestCheckEvent(level, crop, pos, face, hitResult, player, hand);
    }

    private static void dropStacks(ServerLevel level, BlockPos pos, Direction face, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (level.m_8055_(pos).m_60812_((BlockGetter)level, pos) != Shapes.m_83040_()) {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)face, (ItemStack)stack);
                continue;
            }
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    private static boolean isTallButSeparate(Block crop) {
        return "farmersdelight:tomatoes".equalsIgnoreCase(BlockUtils.getStringKey((Block)crop));
    }

    private static void logError(Exception e, BlockPos pos) {
        Constants.LOGGER.debug("Exception generated by block at [{}]", (Object)pos.m_123344_());
        Constants.LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod {}", (Object)"harvest_with_ease");
        Constants.LOGGER.debug("Most likely, it wasn't possible to retrieve a crop age property, either for an invalid item in the cropIds configuration option or for a mod incompatibility; see stack trace for more details", (Throwable)e);
    }
}

