/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entities.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.network.BaseMessageClient;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SegmentMessage
extends BaseMessageClient {
    public int id;
    public boolean add;
    public int index;
    public Vec pos;
    public Direction topFacing;
    public Direction bottomFacing;

    public SegmentMessage(FriendlyByteBuf buf) {
        super(buf);
    }

    public SegmentMessage(int id, boolean add, int index, Vec pos, Direction topfacing, Direction bottomfacing) {
        this.id = id;
        this.add = add;
        this.index = index;
        this.pos = pos;
        this.topFacing = topfacing;
        this.bottomFacing = bottomfacing;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.add = buf.readBoolean();
        this.index = buf.readInt();
        this.pos = new Vec(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.topFacing = (Direction)buf.m_130066_(Direction.class);
        this.bottomFacing = (Direction)buf.m_130066_(Direction.class);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.add);
        buf.writeInt(this.index);
        buf.writeDouble(this.pos.x);
        buf.writeDouble(this.pos.y);
        buf.writeDouble(this.pos.z);
        buf.m_130068_((Enum)this.topFacing);
        buf.m_130068_((Enum)this.bottomFacing);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void processMessage(NetworkEvent.Context ctx) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Entity grapple = world.m_6815_(this.id);
        if (grapple == null) {
            return;
        }
        if (grapple instanceof GrapplehookEntity) {
            SegmentHandler segmenthandler = ((GrapplehookEntity)grapple).segmentHandler;
            if (this.add) {
                segmenthandler.actuallyAddSegment(this.index, this.pos, this.bottomFacing, this.topFacing);
            } else {
                segmenthandler.removeSegment(this.index);
            }
        }
    }
}

