/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.network.BaseMessageServer;
import com.yyon.grapplinghook.server.ServerControllerManager;
import java.util.HashSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class GrappleEndMessage
extends BaseMessageServer {
    public int entityId;
    public HashSet<Integer> hookEntityIds;

    public GrappleEndMessage(FriendlyByteBuf buf) {
        super(buf);
    }

    public GrappleEndMessage(int entityId, HashSet<Integer> hookEntityIds) {
        this.entityId = entityId;
        this.hookEntityIds = hookEntityIds;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        int size = buf.readInt();
        this.hookEntityIds = new HashSet();
        for (int i = 0; i < size; ++i) {
            this.hookEntityIds.add(buf.readInt());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.hookEntityIds.size());
        for (int id : this.hookEntityIds) {
            buf.writeInt(id);
        }
    }

    @Override
    public void processMessage(NetworkEvent.Context ctx) {
        int id = this.entityId;
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level w = player.m_9236_();
        ServerControllerManager.receiveGrappleEnd(id, w, this.hookEntityIds);
    }
}

