/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.FlameRingEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class HellsRodItem
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_fire.png");
    private static final int COST = 900;
    private static final int COOLDOWN = 1200;

    public HellsRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockPos pos = ctx.m_8083_();
        if (player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, false) && !world.m_5776_()) {
            FlameRingEntity entity = (FlameRingEntity)BotaniaEntities.FLAME_RING.m_20615_(world);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_((Item)this, ManaItemHandler.instance().hasProficiency(player, stack) ? 600 : 1200);
            }
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, true);
            world.m_142346_((Entity)player, GameEvent.f_157778_, pos);
            ctx.m_43725_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), BotaniaSounds.fireRod, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.m_58904_();
            BlockPos pos = te.m_58899_();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, pos, te.m_58900_(), te, null);
            if (!world.f_46443_ && receiver.getCurrentMana() >= 900 && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
                FlameRingEntity entity = (FlameRingEntity)BotaniaEntities.FLAME_RING.m_20615_(world);
                entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                world.m_7967_((Entity)entity);
                receiver.receiveMana(-900);
                world.m_142346_(null, GameEvent.f_157778_, pos);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }
}

