/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.lib.BotaniaTags;

public class FloralFertilizerItem
extends Item {
    private static final int RANGE = 3;

    public FloralFertilizerItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (!world.f_46443_) {
            BlockState belowState;
            Optional flowersTag = BuiltInRegistries.f_256975_.m_203431_(BotaniaTags.Blocks.MYSTICAL_FLOWERS);
            Optional mushroomsTag = BuiltInRegistries.f_256975_.m_203431_(BotaniaTags.Blocks.SHIMMERING_MUSHROOMS);
            boolean flowersAvailable = flowersTag.map(holders -> holders.m_203632_() > 0).orElse(false);
            boolean mushroomsAvailable = mushroomsTag.map(holders -> holders.m_203632_() > 0).orElse(false);
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (BlockPos candidatePos : BlockPos.m_121976_((int)(pos.m_123341_() - 3), (int)(pos.m_123342_() - 2), (int)(pos.m_123343_() - 3), (int)(pos.m_123341_() + 3), (int)(pos.m_123342_() + 2), (int)(pos.m_123343_() + 3))) {
                if (!world.m_46739_(candidatePos) || !world.m_46859_(candidatePos)) continue;
                belowState = world.m_8055_(candidatePos.m_7495_());
                if ((!flowersAvailable || !FloralFertilizerItem.canPlaceFlower(belowState, world)) && (!mushroomsAvailable || !FloralFertilizerItem.canPlaceMushroom(belowState))) continue;
                validCoords.add(candidatePos.m_7949_());
            }
            int petalCount = world.f_46441_.m_216332_(5, 7);
            while (petalCount > 0 && !validCoords.isEmpty()) {
                Optional toPlace;
                boolean tryPlaceMushroom;
                --petalCount;
                BlockPos coords = (BlockPos)validCoords.get(world.f_46441_.m_188503_(validCoords.size()));
                validCoords.remove(coords);
                belowState = world.m_8055_(coords.m_7495_());
                boolean tryPlaceFlower = flowersAvailable && FloralFertilizerItem.canPlaceFlower(belowState, world);
                boolean bl = tryPlaceMushroom = mushroomsAvailable && FloralFertilizerItem.canPlaceMushroom(belowState);
                if (tryPlaceMushroom && (!tryPlaceFlower || world.f_46441_.m_188503_(3) == 0)) {
                    toPlace = ((HolderSet.Named)mushroomsTag.get()).m_213653_(world.f_46441_);
                } else {
                    if (!tryPlaceFlower) continue;
                    toPlace = ((HolderSet.Named)flowersTag.get()).m_213653_(world.f_46441_);
                    --petalCount;
                }
                if (!toPlace.isPresent() || ((Block)((Holder)toPlace.get()).m_203334_()).m_49966_().m_60795_()) continue;
                world.m_46597_(coords, ((Block)((Holder)toPlace.get()).m_203334_()).m_49966_());
            }
            ctx.m_43722_().m_41774_(1);
        } else {
            for (int i = 0; i < 15; ++i) {
                double x = (double)(pos.m_123341_() - 3 + world.f_46441_.m_188503_(7)) + Math.random();
                double y = pos.m_123342_() + 1;
                double z = (double)(pos.m_123343_() - 3 + world.f_46441_.m_188503_(7)) + Math.random();
                float red = (float)Math.random();
                float green = (float)Math.random();
                float blue = (float)Math.random();
                WispParticleData data = WispParticleData.wisp(0.15f + (float)Math.random() * 0.25f, red, green, blue, 1.0f);
                world.m_7106_((ParticleOptions)data, x, y, z, 0.0, (double)((float)Math.random() * 0.1f - 0.05f), 0.0);
            }
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    private static boolean canPlaceMushroom(BlockState belowState) {
        return belowState.m_204336_(BlockTags.f_13057_);
    }

    private static boolean canPlaceFlower(BlockState belowState, Level world) {
        return belowState.m_204336_(BlockTags.f_144274_) && !world.m_6042_().f_63857_();
    }
}

