/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import vazkii.botania.client.model.DelegatedModel;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterBakedModel
extends DelegatedModel {
    private final Map<Pair<Item, Boolean>, BakedModel> models;
    private final ItemOverrides itemHandler = new ItemOverrides(){

        @NotNull
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            boolean clip = ManaBlasterItem.hasClip(stack);
            ItemStack lens = ManaBlasterItem.getLens(stack);
            Pair key = Pair.of((Object)(lens.m_41619_() ? null : lens.m_41720_()), (Object)clip);
            return ManaBlasterBakedModel.this.models.getOrDefault(key, Minecraft.m_91087_().m_91304_().m_119409_());
        }
    };

    private ManaBlasterBakedModel(Map<Pair<Item, Boolean>, BakedModel> models) {
        super(models.get(Pair.of(null, (Object)false)));
        this.models = models;
    }

    public static ManaBlasterBakedModel create(ModelBaker baker, ResourceLocation gunNoClip, ResourceLocation gunClip, ModelState state) {
        BakedModel gunNoClipModel = (BakedModel)Preconditions.checkNotNull((Object)baker.m_245240_(gunNoClip, state));
        BakedModel gunClipModel = (BakedModel)Preconditions.checkNotNull((Object)baker.m_245240_(gunClip, state));
        HashMap<Pair<Item, Boolean>, BakedModel> models = new HashMap<Pair<Item, Boolean>, BakedModel>();
        models.put(Pair.of(null, (Object)false), gunNoClipModel);
        models.put(Pair.of(null, (Object)true), gunClipModel);
        for (Item item : BuiltInRegistries.f_257033_) {
            ItemStack lens = item.m_7968_();
            if (!ManaBlasterItem.isValidLens(lens)) continue;
            models.put((Pair<Item, Boolean>)Pair.of((Object)item, (Object)false), new CompositeBakedModel(baker, lens, gunNoClipModel));
            models.put((Pair<Item, Boolean>)Pair.of((Object)item, (Object)true), new CompositeBakedModel(baker, lens, gunClipModel));
        }
        return new ManaBlasterBakedModel(models);
    }

    @Override
    @NotNull
    public ItemOverrides m_7343_() {
        return this.itemHandler;
    }

    @Override
    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.originalModel.m_213637_(state, side, rand);
    }

    private static class CompositeBakedModel
    extends DelegatedModel {
        private final BakedModel lensModel;

        CompositeBakedModel(ModelBaker baker, ItemStack lens, BakedModel gun) {
            super(gun);
            ResourceLocation lensId = BuiltInRegistries.f_257033_.m_7981_((Object)lens.m_41720_());
            ModelState transform = new ModelState(){

                public Transformation m_6189_() {
                    return new Transformation(new Vector3f(-0.4f, 0.2f, 0.0f), VecHelper.rotateY(90.0f), new Vector3f(0.625f, 0.625f, 0.625f), null);
                }
            };
            this.lensModel = baker.m_245240_((ResourceLocation)new ModelResourceLocation(lensId, "inventory"), transform);
        }

        @Override
        @NotNull
        public List<BakedQuad> m_213637_(BlockState state, Direction face, @NotNull RandomSource rand) {
            List gunQuads = this.originalModel.m_213637_(state, face, rand);
            List lensQuads = this.lensModel.m_213637_(state, face, rand);
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(gunQuads.size() + lensQuads.size());
            ret.addAll(gunQuads);
            ret.addAll(lensQuads);
            return ret;
        }
    }
}

