/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.ClientCategory;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class AutoMapConfirmation
extends JmUI {
    Button buttonOptions;
    Button buttonAll;
    Button buttonMissing;
    Button buttonClose;

    public AutoMapConfirmation() {
        this((JmUI)null);
    }

    public AutoMapConfirmation(JmUI returnDisplay) {
        super(Constants.getString("jm.common.automap_dialog"), returnDisplay);
    }

    @Override
    public void m_7856_() {
        this.getRenderables().clear();
        super.setRenderBottomBar(true);
        this.buttonOptions = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Cartography)));
        this.buttonAll = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.automap_dialog_all"), button -> this.initAutoMapping(true, Boolean.TRUE)));
        this.buttonMissing = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.automap_dialog_missing"), button -> this.initAutoMapping(true, Boolean.FALSE)));
        this.buttonClose = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonOptions.setDefaultStyle(false);
        this.buttonAll.setDefaultStyle(false);
        this.buttonMissing.setDefaultStyle(false);
        this.buttonClose.setDefaultStyle(false);
        this.getRenderables().add((Renderable)this.buttonOptions);
        this.getRenderables().add((Renderable)this.buttonAll);
        this.getRenderables().add((Renderable)this.buttonMissing);
        this.getRenderables().add((Renderable)this.buttonClose);
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics) {
        if (this.getRenderables().isEmpty()) {
            this.m_7856_();
        }
        int x = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9 + 3;
        int y = 35 + lineHeight * 2;
        graphics.m_280137_(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_summary_1"), x, y, 0xFFFFFF);
        graphics.m_280137_(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_summary_2"), x, y += lineHeight, 0xFFFFFF);
        this.buttonOptions.centerHorizontalOn(x).centerVerticalOn(y += lineHeight * 2);
        graphics.m_280137_(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_text"), x, y += lineHeight * 3, 0xFFFF00);
        ButtonList buttons = new ButtonList(this.buttonAll, this.buttonMissing);
        buttons.equalizeWidths(this.f_96547_, 4, 200);
        buttons.layoutCenteredHorizontal(x, y += lineHeight * 2, true, 4);
        this.buttonClose.centerHorizontalOn(x).below(this.buttonMissing, lineHeight);
    }

    protected void initAutoMapping(final boolean enable, final Object arg) {
        MapRegionTask.MAP_TYPE = Fullscreen.state().getMapType();
        JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

            @Override
            public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, enable, arg);
                return null;
            }

            @Override
            public String getName() {
                return "Automap";
            }
        });
        this.closeAndReturn();
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }
}

