/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxProvider;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.api.misc.FluxConfigurationType;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public class ItemFluxConfigurator
extends Item {
    public ItemFluxConfigurator(Item.Properties props) {
        super(props);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof TileFluxDevice) {
            TileFluxDevice device = (TileFluxDevice)blockEntity;
            if (!device.canPlayerAccess(player)) {
                player.m_5661_(FluxTranslate.ACCESS_DENIED, true);
                return InteractionResult.FAIL;
            }
            if (player.m_6144_()) {
                tag = stack.m_41698_("FluxConfig");
                for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
                    type.copy(player, tag, device);
                }
                player.m_5661_(FluxTranslate.CONFIG_COPIED, false);
            } else {
                tag = stack.m_41737_("FluxConfig");
                if (tag != null) {
                    for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
                        type.paste(player, tag, device);
                    }
                    player.m_5661_(FluxTranslate.CONFIG_PASTED, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new Provider(stack), buf -> buf.writeBoolean(false));
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        CompoundTag tag = stack.m_41737_("FluxConfig");
        if (tag != null) {
            FluxNetwork network = ClientCache.getNetwork(tag.m_128451_("networkID"));
            if (network.isValid()) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + FluxTranslate.NETWORK_FULL_NAME.get() + ": " + ChatFormatting.RESET + network.getNetworkName())));
            }
            if (tag.m_128441_("limit")) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + FluxTranslate.TRANSFER_LIMIT.get() + ": " + ChatFormatting.RESET + EnergyType.FE.getStorage(tag.m_128454_("limit")))));
            }
            if (tag.m_128441_("priority")) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + FluxTranslate.PRIORITY.get() + ": " + ChatFormatting.RESET + tag.m_128451_("priority"))));
            }
        }
    }

    public static class Provider
    implements IFluxProvider {
        public final ItemStack mStack;

        public Provider(@Nonnull ItemStack stack) {
            this.mStack = stack;
        }

        @Override
        public int getNetworkID() {
            CompoundTag tag = this.mStack.m_41737_("FluxConfig");
            return tag != null ? tag.m_128451_("networkID") : -1;
        }

        @Override
        public void onPlayerOpened(@Nonnull Player player) {
        }

        @Override
        public void onPlayerClosed(@Nonnull Player player) {
        }

        @Nullable
        public FluxMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new FluxMenu(containerId, inventory, this);
        }
    }
}

