/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.capability;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.common.util.FluxUtils;

@AutoRegisterCapability
public class FluxPlayer {
    public static final Capability<FluxPlayer> FLUX_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<FluxPlayer>(){});
    public static final String SUPER_ADMIN_KEY = "superAdmin";
    private boolean mSuperAdmin;
    private int mWirelessMode;
    private int mWirelessNetwork;

    public boolean isSuperAdmin() {
        return this.mSuperAdmin;
    }

    public boolean setSuperAdmin(boolean superAdmin) {
        if (this.mSuperAdmin != superAdmin) {
            this.mSuperAdmin = superAdmin;
            return true;
        }
        return false;
    }

    public int getWirelessMode() {
        return this.mWirelessMode;
    }

    public void setWirelessMode(int wirelessMode) {
        this.mWirelessMode = wirelessMode;
    }

    public int getWirelessNetwork() {
        return this.mWirelessNetwork;
    }

    public void setWirelessNetwork(int wirelessNetwork) {
        this.mWirelessNetwork = wirelessNetwork;
    }

    public void set(FluxPlayer other) {
        this.mSuperAdmin = other.mSuperAdmin;
        this.mWirelessMode = other.mWirelessMode;
        this.mWirelessNetwork = other.mWirelessNetwork;
    }

    public void writeNBT(@Nonnull CompoundTag tag) {
        tag.m_128379_(SUPER_ADMIN_KEY, this.mSuperAdmin);
        tag.m_128405_("wirelessMode", this.mWirelessMode);
        tag.m_128405_("wirelessNetwork", this.mWirelessNetwork);
    }

    public void readNBT(@Nonnull CompoundTag tag) {
        this.mSuperAdmin = tag.m_128471_(SUPER_ADMIN_KEY);
        this.mWirelessMode = tag.m_128451_("wirelessMode");
        this.mWirelessNetwork = tag.m_128451_("wirelessNetwork");
    }

    public static boolean canActivateSuperAdmin(Player player) {
        return FluxConfig.enableSuperAdmin && player.m_20310_(FluxConfig.superAdminRequiredPermission);
    }

    public static boolean isPlayerSuperAdmin(@Nonnull Player player) {
        if (FluxConfig.enableSuperAdmin) {
            FluxPlayer fluxPlayer = FluxUtils.get((ICapabilityProvider)player, FLUX_PLAYER);
            return fluxPlayer != null && fluxPlayer.isSuperAdmin();
        }
        return false;
    }
}

