/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.device.TileFluxStorage;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;

@ParametersAreNonnullByDefault
public abstract class FluxStorageBlock
extends FluxDeviceBlock {
    protected FluxStorageBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add(FluxTranslate.FLUX_STORAGE_TOOLTIP.getComponent());
        tooltip.add((Component)FluxTranslate.FLUX_STORAGE_TOOLTIP_2.makeComponent(EnergyType.FE.getStorage(this.getEnergyCapacity())));
    }

    public abstract long getEnergyCapacity();

    public static class Gargantuan
    extends FluxStorageBlock {
        public Gargantuan(BlockBehaviour.Properties props) {
            super(props);
        }

        @Override
        public long getEnergyCapacity() {
            return FluxConfig.gargantuanCapacity;
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new TileFluxStorage.Gargantuan(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            if (type == RegistryBlockEntityTypes.GARGANTUAN_FLUX_STORAGE.get()) {
                return TileFluxDevice.getTicker(level);
            }
            return null;
        }
    }

    public static class Herculean
    extends FluxStorageBlock {
        public Herculean(BlockBehaviour.Properties props) {
            super(props);
        }

        @Override
        public long getEnergyCapacity() {
            return FluxConfig.herculeanCapacity;
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new TileFluxStorage.Herculean(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            if (type == RegistryBlockEntityTypes.HERCULEAN_FLUX_STORAGE.get()) {
                return TileFluxDevice.getTicker(level);
            }
            return null;
        }
    }

    public static class Basic
    extends FluxStorageBlock {
        public Basic(BlockBehaviour.Properties props) {
            super(props);
        }

        @Override
        public long getEnergyCapacity() {
            return FluxConfig.basicCapacity;
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new TileFluxStorage.Basic(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            if (type == RegistryBlockEntityTypes.BASIC_FLUX_STORAGE.get()) {
                return TileFluxDevice.getTicker(level);
            }
            return null;
        }
    }
}

