/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.InventoryButton;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.button.SwitchButton;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabWireless
extends GuiTabCore {
    public SwitchButton mEnable;
    public SimpleButton mApply;
    public int mWirelessMode;

    public GuiTabWireless(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_WIRELESS;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid()) {
            int color = this.getNetwork().getNetworkColor();
            gr.m_280137_(this.f_96547_, FluxTranslate.TAB_WIRELESS.get(), this.f_97735_ + 88, this.f_97736_ + 10, 0xB4B4B4);
            gr.m_280488_(this.f_96547_, FluxTranslate.ENABLE_WIRELESS.get(), this.f_97735_ + 20, this.f_97736_ + 148, color);
            if (WirelessType.ENABLE_WIRELESS.isActivated(ClientCache.sWirelessMode) && ClientCache.sWirelessNetwork == this.getNetwork().getNetworkID()) {
                gr.m_280137_(this.f_96547_, "(" + FluxTranslate.EFFECTIVE_WIRELESS_NETWORK.get() + ")", this.f_97735_ + 88, this.f_97736_ + 158, color);
            } else {
                gr.m_280137_(this.f_96547_, "(" + FluxTranslate.INEFFECTIVE_WIRELESS_NETWORK.get() + ")", this.f_97735_ + 88, this.f_97736_ + 158, 0xB4B4B4);
            }
        } else {
            this.renderNavigationPrompt(gr, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.getNetwork().isValid()) {
            this.mWirelessMode = ClientCache.sWirelessMode;
            this.mEnable = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 148, WirelessType.ENABLE_WIRELESS.isActivated(this.mWirelessMode), this.getNetwork().getNetworkColor());
            this.mButtons.add(this.mEnable);
            this.mButtons.add(new InventoryButton(this, this.f_97735_ + 24, this.f_97736_ + 28, 52, 16, WirelessType.ARMOR, 0, 80));
            this.mButtons.add(new InventoryButton(this, this.f_97735_ + 100, this.f_97736_ + 28, 52, 16, WirelessType.CURIOS, 0, 80));
            this.mButtons.add(new InventoryButton(this, this.f_97735_ + 32, this.f_97736_ + 52, 112, 40, WirelessType.INVENTORY, 0, 0));
            this.mButtons.add(new InventoryButton(this, this.f_97735_ + 32, this.f_97736_ + 100, 112, 16, WirelessType.HOT_BAR, 112, 0));
            this.mButtons.add(new InventoryButton(this, this.f_97735_ + 136, this.f_97736_ + 124, 16, 16, WirelessType.MAIN_HAND, 52, 80));
            this.mButtons.add(new InventoryButton(this, this.f_97735_ + 24, this.f_97736_ + 124, 16, 16, WirelessType.OFF_HAND, 52, 80));
            this.mApply = new SimpleButton(this, this.f_97735_ + this.f_97726_ / 2 - 24, this.f_97736_ + 126, 48, 12, FluxTranslate.APPLY.get());
            this.mApply.setClickable(ClientCache.sWirelessNetwork != this.getNetwork().getNetworkID());
            this.mButtons.add(this.mApply);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        if (button instanceof InventoryButton) {
            InventoryButton btn = (InventoryButton)button;
            if (btn.mType != WirelessType.INVENTORY) {
                this.mWirelessMode ^= 1 << btn.mType.ordinal();
                this.mApply.setClickable(true);
            }
        } else if (button instanceof SwitchButton) {
            SwitchButton btn = (SwitchButton)button;
            btn.toggle();
            this.mWirelessMode = btn.isChecked() ? (this.mWirelessMode |= 1 << WirelessType.ENABLE_WIRELESS.ordinal()) : (this.mWirelessMode &= ~(1 << WirelessType.ENABLE_WIRELESS.ordinal()));
            this.mApply.setClickable(true);
        } else if (button == this.mApply) {
            ClientMessages.wirelessMode(this.getToken(), this.mWirelessMode, this.getNetwork().getNetworkID());
            this.mApply.setClickable(false);
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.getNetwork().isValid()) {
            return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
        }
        return false;
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code > 0) {
            this.mWirelessMode = ClientCache.sWirelessMode;
            if (this.mEnable != null) {
                this.mEnable.setChecked(WirelessType.ENABLE_WIRELESS.isActivated(this.mWirelessMode));
            }
        }
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.mEnable != null) {
            this.mEnable.setColor(this.getNetwork().getNetworkColor());
        }
    }
}

