/*
 * Decompiled with CFR 0.152.
 */
package dev.enemeez.simplefarming.common.registries;

import dev.enemeez.simplefarming.common.item.AlcoholItem;
import dev.enemeez.simplefarming.common.item.GrainCropItem;
import dev.enemeez.simplefarming.common.item.RootCropItem;
import dev.enemeez.simplefarming.common.item.ScytheItem;
import dev.enemeez.simplefarming.common.item.SeedItem;
import dev.enemeez.simplefarming.common.item.SeedPacketItem;
import dev.enemeez.simplefarming.common.registries.ModBlocks;
import dev.enemeez.simplefarming.common.registries.ModFoods;
import dev.enemeez.simplefarming.common.registries.ModSoundEvents;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simplefarming");
    public static final LinkedList<RegistryObject<Item>> ITEM_LIST = new LinkedList();
    public static final Map<RegistryObject<Item>, Float> COMPOSTABLES = new HashMap<RegistryObject<Item>, Float>();
    public static final LinkedList<RegistryObject<Item>> SEEDS = new LinkedList();
    public static final RegistryObject<Item> BLACKBERRY_BUSH = ModItems.registerBlockItem("blackberry_bush", ModBlocks.BLACKBERRY_BUSH, 0.3f);
    public static final RegistryObject<Item> BLUEBERRY_BUSH = ModItems.registerBlockItem("blueberry_bush", ModBlocks.BLUEBERRY_BUSH, 0.3f);
    public static final RegistryObject<Item> RASPBERRY_BUSH = ModItems.registerBlockItem("raspberry_bush", ModBlocks.RASPBERRY_BUSH, 0.3f);
    public static final RegistryObject<Item> STRAWBERRY_BUSH = ModItems.registerBlockItem("strawberry_bush", ModBlocks.STRAWBERRY_BUSH, 0.3f);
    public static final RegistryObject<Item> OPUNTIA = ModItems.registerBlockItem("opuntia", ModBlocks.OPUNTIA, 0.5f);
    public static final RegistryObject<Item> BARLEY_HAY_BLOCK = ModItems.registerBlockItem("barley_hay_block", ModBlocks.BARLEY_HAY_BLOCK, 0.85f);
    public static final RegistryObject<Item> OAT_HAY_BLOCK = ModItems.registerBlockItem("oat_hay_block", ModBlocks.OAT_HAY_BLOCK, 0.85f);
    public static final RegistryObject<Item> RICE_HAY_BLOCK = ModItems.registerBlockItem("rice_hay_block", ModBlocks.RICE_HAY_BLOCK, 0.85f);
    public static final RegistryObject<Item> RYE_HAY_BLOCK = ModItems.registerBlockItem("rye_hay_block", ModBlocks.RYE_HAY_BLOCK, 0.85f);
    public static final RegistryObject<Item> FERMENTER = ModItems.registerBlockItem("fermenter", ModBlocks.FERMENTER);
    public static final RegistryObject<Item> CANTALOUPE_BLOCK = ModItems.registerBlockItem("cantaloupe_block", ModBlocks.CANTALOUPE, 1.0f);
    public static final RegistryObject<Item> HONEYDEW_BLOCK = ModItems.registerBlockItem("honeydew_block", ModBlocks.HONEYDEW, 1.0f);
    public static final RegistryObject<Item> SQUASH_BLOCK = ModItems.registerBlockItem("squash_block", ModBlocks.SQUASH, 1.0f);
    public static final RegistryObject<Item> APPLE_SAPLING = ModItems.registerBlockItem("apple_sapling", ModBlocks.APPLE_SAPLING, 0.3f);
    public static final RegistryObject<Item> APRICOT_SAPLING = ModItems.registerBlockItem("apricot_sapling", ModBlocks.APRICOT_SAPLING, 0.3f);
    public static final RegistryObject<Item> BANANA_SAPLING = ModItems.registerBlockItem("banana_sapling", ModBlocks.BANANA_SAPLING, 0.3f);
    public static final RegistryObject<Item> CHERRY_SAPLING = ModItems.registerBlockItem("cherry_sapling", ModBlocks.CHERRY_SAPLING, 0.3f);
    public static final RegistryObject<Item> MANGO_SAPLING = ModItems.registerBlockItem("mango_sapling", ModBlocks.MANGO_SAPLING, 0.3f);
    public static final RegistryObject<Item> OLIVE_SAPLING = ModItems.registerBlockItem("olive_sapling", ModBlocks.OLIVE_SAPLING, 0.3f);
    public static final RegistryObject<Item> ORANGE_SAPLING = ModItems.registerBlockItem("orange_sapling", ModBlocks.ORANGE_SAPLING, 0.3f);
    public static final RegistryObject<Item> PEAR_SAPLING = ModItems.registerBlockItem("pear_sapling", ModBlocks.PEAR_SAPLING, 0.3f);
    public static final RegistryObject<Item> PLUM_SAPLING = ModItems.registerBlockItem("plum_sapling", ModBlocks.PLUM_SAPLING, 0.3f);
    public static final RegistryObject<Item> SCARECROW = ModItems.registerBlockItem("scarecrow", ModBlocks.SCARECROW);
    public static final RegistryObject<Item> TRELLIS = ModItems.registerBlockItem("trellis", ModBlocks.TRELLIS);
    public static final RegistryObject<Item> CHOCOLATE_CAKE = ModItems.registerCakeLike("chocolate_cake", ModBlocks.CHOCOLATE_CAKE);
    public static final RegistryObject<Item> SPRINKLE_CAKE = ModItems.registerCakeLike("sprinkle_cake", ModBlocks.SPRINKLE_CAKE);
    public static final RegistryObject<Item> CHEESE_WHEEL = ModItems.registerCakeLike("cheese_wheel", ModBlocks.CHEESE_WHEEL);
    public static final RegistryObject<Item> WOODEN_SCYTHE = ModItems.registerScythe("wooden_scythe", (Tier)Tiers.WOOD);
    public static final RegistryObject<Item> STONE_SCYTHE = ModItems.registerScythe("stone_scythe", (Tier)Tiers.STONE);
    public static final RegistryObject<Item> IRON_SCYTHE = ModItems.registerScythe("iron_scythe", (Tier)Tiers.IRON);
    public static final RegistryObject<Item> GOLDEN_SCYTHE = ModItems.registerScythe("golden_scythe", (Tier)Tiers.GOLD);
    public static final RegistryObject<Item> DIAMOND_SCYTHE = ModItems.registerScythe("diamond_scythe", (Tier)Tiers.DIAMOND);
    public static final RegistryObject<Item> NETHERITE_SCYTHE = ModItems.registerScythe("netherite_scythe", (Tier)Tiers.NETHERITE);
    public static final RegistryObject<Item> MUSIC_DISC_NOURISH = ModItems.registerMusicDisc("music_disc_nourish", 2340);
    public static final RegistryObject<Item> FIBER_SEED_PACKET = ModItems.registerSeedPacket("fiber_seed_packet", SeedPacketItem.Type.FIBER);
    public static final RegistryObject<Item> FRUIT_SEED_PACKET = ModItems.registerSeedPacket("fruit_seed_packet", SeedPacketItem.Type.FRUIT);
    public static final RegistryObject<Item> GOURD_SEED_PACKET = ModItems.registerSeedPacket("gourd_seed_packet", SeedPacketItem.Type.GOURD);
    public static final RegistryObject<Item> GRAIN_SEED_PACKET = ModItems.registerSeedPacket("grain_seed_packet", SeedPacketItem.Type.GRAIN);
    public static final RegistryObject<Item> LEAFY_SEED_PACKET = ModItems.registerSeedPacket("leafy_seed_packet", SeedPacketItem.Type.LEAFY);
    public static final RegistryObject<Item> LEGUME_SEED_PACKET = ModItems.registerSeedPacket("legume_seed_packet", SeedPacketItem.Type.LEGUME);
    public static final RegistryObject<Item> ROOT_SEED_PACKET = ModItems.registerSeedPacket("root_seed_packet", SeedPacketItem.Type.ROOT);
    public static final RegistryObject<Item> TUBER_SEED_PACKET = ModItems.registerSeedPacket("tuber_seed_packet", SeedPacketItem.Type.TUBER);
    public static final RegistryObject<Item> GRAPES = ModItems.registerFood("grapes", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> APRICOT = ModItems.registerFood("apricot", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> BANANA = ModItems.registerFood("banana", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> CHERRIES = ModItems.registerFood("cherries", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> MANGO = ModItems.registerFood("mango", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> OLIVES = ModItems.registerFood("olives", ModFoods.OLIVES, 0.65f);
    public static final RegistryObject<Item> ORANGE = ModItems.registerFood("orange", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> PEAR = ModItems.registerFood("pear", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> PLUM = ModItems.registerFood("plum", ModFoods.FRUIT, 0.65f);
    public static final RegistryObject<Item> CANTALOUPE = ModItems.registerFood("cantaloupe", ModFoods.GOURD_SLICE, 0.3f);
    public static final RegistryObject<Item> HONEYDEW = ModItems.registerFood("honeydew", ModFoods.GOURD_SLICE, 0.3f);
    public static final RegistryObject<Item> SQUASH = ModItems.registerFood("squash", ModFoods.GOURD_SLICE, 0.3f);
    public static final RegistryObject<Item> BLACKBERRIES = ModItems.registerFood("blackberries", ModFoods.BERRY, 0.3f);
    public static final RegistryObject<Item> BLUEBERRIES = ModItems.registerFood("blueberries", ModFoods.BERRY, 0.3f);
    public static final RegistryObject<Item> RASPBERRIES = ModItems.registerFood("raspberries", ModFoods.BERRY, 0.3f);
    public static final RegistryObject<Item> STRAWBERRIES = ModItems.registerFood("strawberries", ModFoods.BERRY, 0.3f);
    public static final RegistryObject<Item> CACTUS_FRUIT = ModItems.registerFood("cactus_fruit", ModFoods.BERRY, 0.3f);
    public static final RegistryObject<Item> BROCCOLI = ModItems.registerFood("broccoli", ModFoods.BROCCOLI, 0.65f);
    public static final RegistryObject<Item> CASSAVA = ModItems.registerFood("cassava", ModFoods.CASSAVA, 0.65f);
    public static final RegistryObject<Item> CORN = ModItems.registerGrainCropItem("corn", ModFoods.CORN);
    public static final RegistryObject<Item> CUCUMBER = ModItems.registerFood("cucumber", ModFoods.CUCUMBER, 0.65f);
    public static final RegistryObject<Item> EGGPLANT = ModItems.registerFood("eggplant", ModFoods.EGGPLANT, 0.65f);
    public static final RegistryObject<Item> HABANERO = ModItems.registerFood("habanero", ModFoods.PEPPER, 0.65f);
    public static final RegistryObject<Item> GINGER = ModItems.registerFood("ginger", ModFoods.GINGER, 0.65f);
    public static final RegistryObject<Item> LETTUCE = ModItems.registerFood("lettuce", ModFoods.SALAD_GREENS, 0.65f);
    public static final RegistryObject<Item> ONION = ModItems.registerRootCropItem("onion", ModFoods.ONION);
    public static final RegistryObject<Item> PEA_POD = ModItems.registerFood("pea_pod", ModFoods.PEA_POD, 0.65f);
    public static final RegistryObject<Item> PEANUT = ModItems.registerFood("peanut", ModFoods.PEANUT, 0.65f);
    public static final RegistryObject<Item> PEPPER = ModItems.registerFood("pepper", ModFoods.PEPPER, 0.65f);
    public static final RegistryObject<Item> RADISH = ModItems.registerRootCropItem("radish", ModFoods.RADISH);
    public static final RegistryObject<Item> SORGHUM = ModItems.registerGrainCropItem("sorghum", ModFoods.SORGHUM);
    public static final RegistryObject<Item> SOYBEAN = ModItems.registerFood("soybean", ModFoods.SOYBEAN, 0.65f);
    public static final RegistryObject<Item> SPINACH = ModItems.registerFood("spinach", ModFoods.SALAD_GREENS, 0.65f);
    public static final RegistryObject<Item> SWEET_POTATO = ModItems.registerRootCropItem("sweet_potato", ModFoods.SWEET_POTATO);
    public static final RegistryObject<Item> TOMATO = ModItems.registerFood("tomato", ModFoods.TOMATO, 0.65f);
    public static final RegistryObject<Item> TURNIP = ModItems.registerRootCropItem("turnip", ModFoods.TURNIP);
    public static final RegistryObject<Item> YAM = ModItems.registerRootCropItem("yam", Foods.f_38799_);
    public static final RegistryObject<Item> ZUCCHINI = ModItems.registerFood("zucchini", ModFoods.ZUCCHINI, 0.65f);
    public static final RegistryObject<Item> COTTON = ModItems.registerItem("cotton", 0.65f);
    public static final RegistryObject<Item> KENAF_FIBER = ModItems.registerItem("kenaf_fiber", 0.65f);
    public static final RegistryObject<Item> BARLEY = ModItems.registerGrainCropItem("barley");
    public static final RegistryObject<Item> OAT = ModItems.registerGrainCropItem("oat");
    public static final RegistryObject<Item> RYE = ModItems.registerGrainCropItem("rye");
    public static final RegistryObject<Item> RICE = ModItems.registerGrainCropItem("rice");
    public static final RegistryObject<Item> CHEESE_SLICE = ModItems.registerFood("cheese_slice", ModFoods.CHEESE_SLICE, 0.3f);
    public static final RegistryObject<Item> CURRY_POWDER = ModItems.registerItem("curry_powder", 0.85f);
    public static final RegistryObject<Item> JAM = ModItems.registerItem("jam");
    public static final RegistryObject<Item> OLIVE_OIL = ModItems.registerItem("olive_oil");
    public static final RegistryObject<Item> VINEGAR = ModItems.registerItem("vinegar");
    public static final RegistryObject<Item> SPRINKLES = ModItems.registerItem("sprinkles", 0.3f);
    public static final RegistryObject<Item> NOODLES = ModItems.registerItem("noodles", 0.85f);
    public static final RegistryObject<Item> BEER = ModItems.registerAlcohol("beer", MobEffects.f_19600_);
    public static final RegistryObject<Item> CAUIM = ModItems.registerAlcohol("cauim", MobEffects.f_19603_);
    public static final RegistryObject<Item> CIDER = ModItems.registerAlcohol("cider", MobEffects.f_19621_);
    public static final RegistryObject<Item> MEAD = ModItems.registerAlcohol("mead", MobEffects.f_19598_);
    public static final RegistryObject<Item> SAKE = ModItems.registerAlcohol("sake", MobEffects.f_19596_);
    public static final RegistryObject<Item> TISWIN = ModItems.registerAlcohol("tiswin", MobEffects.f_19616_);
    public static final RegistryObject<Item> VODKA = ModItems.registerAlcohol("vodka", MobEffects.f_19606_);
    public static final RegistryObject<Item> WHISKEY = ModItems.registerAlcohol("whiskey", MobEffects.f_19617_);
    public static final RegistryObject<Item> WINE = ModItems.registerAlcohol("wine", MobEffects.f_19605_);
    public static final RegistryObject<Item> BARLEY_SEEDS = ModItems.registerSeed("barley_seeds", ModBlocks.BARLEY);
    public static final RegistryObject<Item> BROCCOLI_SEEDS = ModItems.registerSeed("broccoli_seeds", ModBlocks.BROCCOLI);
    public static final RegistryObject<Item> CANTALOUPE_SEEDS = ModItems.registerSeed("cantaloupe_seeds", ModBlocks.CANTALOUPE_STEM);
    public static final RegistryObject<Item> CORN_SEEDS = ModItems.registerSeed("corn_seeds", ModBlocks.CORN);
    public static final RegistryObject<Item> COTTON_SEEDS = ModItems.registerSeed("cotton_seeds", ModBlocks.COTTON);
    public static final RegistryObject<Item> CASSAVA_SEEDS = ModItems.registerSeed("cassava_seeds", ModBlocks.CASSAVA);
    public static final RegistryObject<Item> CUCUMBER_SEEDS = ModItems.registerSeed("cucumber_seeds", ModBlocks.CUCUMBERS);
    public static final RegistryObject<Item> EGGPLANT_SEEDS = ModItems.registerSeed("eggplant_seeds", ModBlocks.EGGPLANTS);
    public static final RegistryObject<Item> GINGER_SEEDS = ModItems.registerSeed("ginger_seeds", ModBlocks.GINGER);
    public static final RegistryObject<Item> GRAPE_SEEDS = ModItems.registerSeed("grape_seeds", ModBlocks.GRAPE_TRUNK);
    public static final RegistryObject<Item> HONEYDEW_SEEDS = ModItems.registerSeed("honeydew_seeds", ModBlocks.HONEYDEW_STEM);
    public static final RegistryObject<Item> KENAF_SEEDS = ModItems.registerSeed("kenaf_seeds", ModBlocks.KENAF);
    public static final RegistryObject<Item> LETTUCE_SEEDS = ModItems.registerSeed("lettuce_seeds", ModBlocks.LETTUCE);
    public static final RegistryObject<Item> OAT_SEEDS = ModItems.registerSeed("oat_seeds", ModBlocks.OAT);
    public static final RegistryObject<Item> ONION_SEEDS = ModItems.registerSeed("onion_seeds", ModBlocks.ONIONS);
    public static final RegistryObject<Item> PEA_SEEDS = ModItems.registerSeed("pea_seeds", ModBlocks.PEAS);
    public static final RegistryObject<Item> PEANUT_SEEDS = ModItems.registerSeed("peanut_seeds", ModBlocks.PEANUTS);
    public static final RegistryObject<Item> PEPPER_SEEDS = ModItems.registerSeed("pepper_seeds", ModBlocks.PEPPERS);
    public static final RegistryObject<Item> RADISH_SEEDS = ModItems.registerSeed("radish_seeds", ModBlocks.RADISHES);
    public static final RegistryObject<Item> RICE_SEEDS = ModItems.registerSeed("rice_seeds", ModBlocks.RICE);
    public static final RegistryObject<Item> RYE_SEEDS = ModItems.registerSeed("rye_seeds", ModBlocks.RYE);
    public static final RegistryObject<Item> SORGHUM_SEEDS = ModItems.registerSeed("sorghum_seeds", ModBlocks.SORGHUM);
    public static final RegistryObject<Item> SOYBEAN_SEEDS = ModItems.registerSeed("soybean_seeds", ModBlocks.SOYBEANS);
    public static final RegistryObject<Item> SPINACH_SEEDS = ModItems.registerSeed("spinach_seeds", ModBlocks.SPINACH);
    public static final RegistryObject<Item> SQUASH_SEEDS = ModItems.registerSeed("squash_seeds", ModBlocks.SQUASH_STEM);
    public static final RegistryObject<Item> SWEET_POTATO_SEEDS = ModItems.registerSeed("sweet_potato_seeds", ModBlocks.SWEET_POTATOES);
    public static final RegistryObject<Item> TOMATO_SEEDS = ModItems.registerSeed("tomato_seeds", ModBlocks.TOMATOES);
    public static final RegistryObject<Item> TURNIP_SEEDS = ModItems.registerSeed("turnip_seeds", ModBlocks.TURNIPS);
    public static final RegistryObject<Item> YAM_SEEDS = ModItems.registerSeed("yam_seeds", ModBlocks.YAMS);
    public static final RegistryObject<Item> ZUCCHINI_SEEDS = ModItems.registerSeed("zucchini_seeds", ModBlocks.ZUCCHINIS);
    public static final RegistryObject<Item> CHICORY_ROOT = ModItems.registerEdibleSeed("chicory_root", ModBlocks.CHICORY);
    public static final RegistryObject<Item> CUMIN_SEEDS = ModItems.registerEdibleSeed("cumin_seeds", ModBlocks.CUMIN);
    public static final RegistryObject<Item> MARSHMALLOW_ROOT = ModItems.registerEdibleSeed("marshmallow_root", ModBlocks.MARSHMALLOW);
    public static final RegistryObject<Item> QUINOA_SEEDS = ModItems.registerEdibleSeed("quinoa_seeds", ModBlocks.QUINOA);
    public static final RegistryObject<Item> APPLE_PIE = ModItems.registerFood("apple_pie", ModFoods.FRUIT_PIE, 1.0f);
    public static final RegistryObject<Item> APRICOT_PIE = ModItems.registerFood("apricot_pie", ModFoods.FRUIT_PIE, 1.0f);
    public static final RegistryObject<Item> BLACKBERRY_PIE = ModItems.registerFood("blackberry_pie", ModFoods.BERRY_PIE, 1.0f);
    public static final RegistryObject<Item> BLUEBERRY_PIE = ModItems.registerFood("blueberry_pie", ModFoods.BERRY_PIE, 1.0f);
    public static final RegistryObject<Item> CHERRY_PIE = ModItems.registerFood("cherry_pie", ModFoods.FRUIT_PIE, 1.0f);
    public static final RegistryObject<Item> PEANUT_BUTTER_PIE = ModItems.registerFood("peanut_butter_pie", ModFoods.PEANUT_BUTTER_PIE, 1.0f);
    public static final RegistryObject<Item> PEAR_PIE = ModItems.registerFood("pear_pie", ModFoods.FRUIT_PIE, 1.0f);
    public static final RegistryObject<Item> PLUM_PIE = ModItems.registerFood("plum_pie", ModFoods.FRUIT_PIE, 1.0f);
    public static final RegistryObject<Item> RASPBERRY_PIE = ModItems.registerFood("raspberry_pie", ModFoods.BERRY_PIE, 1.0f);
    public static final RegistryObject<Item> STRAWBERRY_PIE = ModItems.registerFood("strawberry_pie", ModFoods.BERRY_PIE, 1.0f);
    public static final RegistryObject<Item> BORSCHT = ModItems.registerBowlFood("borscht", ModFoods.BORSCHT);
    public static final RegistryObject<Item> BROCCOLI_CHEESE_SOUP = ModItems.registerBowlFood("broccoli_cheese_soup", ModFoods.BROCCOLI_CHEESE_SOUP);
    public static final RegistryObject<Item> CAESAR_SALAD = ModItems.registerBowlFood("caesar_salad", ModFoods.CAESAR_SALAD);
    public static final RegistryObject<Item> CARROT_SOUP = ModItems.registerBowlFood("carrot_soup", ModFoods.CARROT_SOUP);
    public static final RegistryObject<Item> CHICKEN_NOODLE_SOUP = ModItems.registerBowlFood("chicken_noodle_soup", ModFoods.CHICKEN_NOODLE_SOUP);
    public static final RegistryObject<Item> CHILI = ModItems.registerBowlFood("chili", ModFoods.CHILI);
    public static final RegistryObject<Item> CORN_SALAD = ModItems.registerBowlFood("corn_salad", ModFoods.CORN_SALAD);
    public static final RegistryObject<Item> CUCUMBER_SOUP = ModItems.registerBowlFood("cucumber_soup", ModFoods.CUCUMBER_SOUP);
    public static final RegistryObject<Item> FRUIT_SALAD = ModItems.registerBowlFood("fruit_salad", ModFoods.FRUIT_SALAD);
    public static final RegistryObject<Item> OATMEAL = ModItems.registerBowlFood("oatmeal", ModFoods.OATMEAL);
    public static final RegistryObject<Item> OLIVE_TOMATO_SALAD = ModItems.registerBowlFood("olive_tomato_salad", ModFoods.OLIVE_TOMATO_SALAD);
    public static final RegistryObject<Item> ONION_SOUP = ModItems.registerBowlFood("onion_soup", ModFoods.ONION_SOUP);
    public static final RegistryObject<Item> PEA_SOUP = ModItems.registerBowlFood("pea_soup", ModFoods.PEA_SOUP);
    public static final RegistryObject<Item> PUMPKIN_SOUP = ModItems.registerBowlFood("pumpkin_soup", ModFoods.PUMPKIN_SOUP);
    public static final RegistryObject<Item> QUINOA_SALAD = ModItems.registerBowlFood("quinoa_salad", ModFoods.QUINOA_SALAD);
    public static final RegistryObject<Item> RADISH_SOUP = ModItems.registerBowlFood("radish_soup", ModFoods.RADISH_SOUP);
    public static final RegistryObject<Item> RICE_BOWL = ModItems.registerBowlFood("rice_bowl", ModFoods.RICE_BOWL);
    public static final RegistryObject<Item> SALAD = ModItems.registerBowlFood("salad", ModFoods.SALAD);
    public static final RegistryObject<Item> SAUSAGE_BARLEY_SOUP = ModItems.registerBowlFood("sausage_barley_soup", ModFoods.SAUSAGE_BARLEY);
    public static final RegistryObject<Item> SORGHUM_PORRIDGE = ModItems.registerBowlFood("sorghum_porridge", ModFoods.SORGHUM_PORRIDGE);
    public static final RegistryObject<Item> SQUASH_SOUP = ModItems.registerBowlFood("squash_soup", ModFoods.SQUASH_SOUP);
    public static final RegistryObject<Item> TOMATO_SOUP = ModItems.registerBowlFood("tomato_soup", ModFoods.TOMATO_SOUP);
    public static final RegistryObject<Item> VEGETABLE_MEDLEY = ModItems.registerBowlFood("vegetable_medley", ModFoods.VEGETABLE_MEDLEY);
    public static final RegistryObject<Item> BANANA_BREAD = ModItems.registerFood("banana_bread", ModFoods.BANANA_BREAD, 0.85f);
    public static final RegistryObject<Item> BARLEY_BREAD = ModItems.registerFood("barley_bread", Foods.f_38815_, 0.85f);
    public static final RegistryObject<Item> CORNBREAD = ModItems.registerFood("cornbread", ModFoods.CORN_BREAD, 0.85f);
    public static final RegistryObject<Item> OAT_BREAD = ModItems.registerFood("oat_bread", Foods.f_38815_, 0.85f);
    public static final RegistryObject<Item> RICE_BREAD = ModItems.registerFood("rice_bread", Foods.f_38815_, 0.85f);
    public static final RegistryObject<Item> RYE_BREAD = ModItems.registerFood("rye_bread", Foods.f_38815_, 0.85f);
    public static final RegistryObject<Item> SORGHUM_BREAD = ModItems.registerFood("sorghum_bread", ModFoods.SORGHUM_BREAD, 0.85f);
    public static final RegistryObject<Item> ZUCCHINI_BREAD = ModItems.registerFood("zucchini_bread", ModFoods.ZUCCHINI_BREAD, 0.85f);
    public static final RegistryObject<Item> BLT = ModItems.registerFood("blt", ModFoods.BLT);
    public static final RegistryObject<Item> CHEESEBURGER = ModItems.registerFood("cheeseburger", ModFoods.CHEESE_BURGER);
    public static final RegistryObject<Item> EGG_SANDWICH = ModItems.registerFood("egg_sandwich", ModFoods.EGG_SANDWICH);
    public static final RegistryObject<Item> FISH_SANDWICH = ModItems.registerFood("fish_sandwich", ModFoods.FISH_SANDWICH);
    public static final RegistryObject<Item> HAMBURGER = ModItems.registerFood("hamburger", ModFoods.HAMBURGER);
    public static final RegistryObject<Item> ITALIAN_BEEF = ModItems.registerFood("italian_beef", ModFoods.ITALIAN_BEEF);
    public static final RegistryObject<Item> HOTDOG = ModItems.registerFood("hotdog", ModFoods.HOTDOG);
    public static final RegistryObject<Item> PBJ = ModItems.registerFood("pbj", ModFoods.PBJ, 1.0f);
    public static final RegistryObject<Item> PULLED_PORK_SANDWICH = ModItems.registerFood("pulled_pork_sandwich", ModFoods.PULLED_PORK_SANDWICH);
    public static final RegistryObject<Item> SANDWICH = ModItems.registerFood("sandwich", ModFoods.SANDWICH, 1.0f);
    public static final RegistryObject<Item> VEGGIE_BURGER = ModItems.registerFood("veggie_burger", ModFoods.VEGGIE_BURGER, 1.0f);
    public static final RegistryObject<Item> RAW_BACON = ModItems.registerFood("raw_bacon", ModFoods.RAW_BACON);
    public static final RegistryObject<Item> RAW_CHICKEN_WINGS = ModItems.registerFood("raw_chicken_wings", ModFoods.RAW_CHICKEN_WINGS);
    public static final RegistryObject<Item> RAW_SAUSAGE = ModItems.registerFood("raw_sausage", ModFoods.RAW_SAUSAGE);
    public static final RegistryObject<Item> COOKED_BACON = ModItems.registerFood("cooked_bacon", ModFoods.COOKED_BACON);
    public static final RegistryObject<Item> COOKED_CHICKEN_WINGS = ModItems.registerFood("cooked_chicken_wings", ModFoods.COOKED_CHICKEN_WINGS);
    public static final RegistryObject<Item> COOKED_EGG = ModItems.registerFood("cooked_egg", ModFoods.COOKED_EGG);
    public static final RegistryObject<Item> COOKED_SAUSAGE = ModItems.registerFood("cooked_sausage", ModFoods.COOKED_SAUSAGE);
    public static final RegistryObject<Item> BEEF_CURRY = ModItems.registerFood("beef_curry", ModFoods.BEEF_CURRY);
    public static final RegistryObject<Item> CHICKEN_CURRY = ModItems.registerFood("chicken_curry", ModFoods.CHICKEN_CURRY);
    public static final RegistryObject<Item> MUTTON_CURRY = ModItems.registerFood("mutton_curry", ModFoods.MUTTON_CURRY);
    public static final RegistryObject<Item> PORK_CURRY = ModItems.registerFood("pork_curry", ModFoods.PORK_CURRY);
    public static final RegistryObject<Item> VEGETABLE_CURRY = ModItems.registerFood("vegetable_curry", ModFoods.VEGETABLE_CURRY, 1.0f);
    public static final RegistryObject<Item> BEEF_AND_BROCCOLI = ModItems.registerFood("beef_and_broccoli", ModFoods.BEEF_AND_BROCCOLI);
    public static final RegistryObject<Item> CHICORY_GRATIN = ModItems.registerFood("chicory_gratin", ModFoods.CHICORY_GRATIN, 1.0f);
    public static final RegistryObject<Item> FISH_AND_CHIPS = ModItems.registerFood("fish_and_chips", ModFoods.FISH_AND_CHIPS);
    public static final RegistryObject<Item> FRIED_RICE = ModItems.registerFood("fried_rice", ModFoods.FRIED_RICE, 1.0f);
    public static final RegistryObject<Item> MAC_AND_CHEESE = ModItems.registerFood("mac_and_cheese", ModFoods.MAC_AND_CHEESE, 1.0f);
    public static final RegistryObject<Item> MUSHROOM_BARLEY = ModItems.registerFood("mushroom_barley", ModFoods.MUSHROOM_BARLEY, 1.0f);
    public static final RegistryObject<Item> PAD_THAI = ModItems.registerFood("pad_thai", ModFoods.PAD_THAI, 1.0f);
    public static final RegistryObject<Item> PASTA = ModItems.registerFood("pasta", ModFoods.PASTA, 1.0f);
    public static final RegistryObject<Item> SPAGHETTI = ModItems.registerFood("spaghetti", ModFoods.SPAGHETTI, 1.0f);
    public static final RegistryObject<Item> SPINACH_MUSHROOM_QUICHE = ModItems.registerFood("spinach_mushroom_quiche", ModFoods.SPINACH_MUSHROOM_QUICHE, 1.0f);
    public static final RegistryObject<Item> SPINACH_QUINOA_QUICHE = ModItems.registerFood("spinach_quinoa_quiche", ModFoods.SPINACH_QUINOA_QUICHE, 1.0f);
    public static final RegistryObject<Item> SQUASH_CASSEROLE = ModItems.registerFood("squash_casserole", ModFoods.SQUASH_CASSEROLE, 1.0f);
    public static final RegistryObject<Item> TOFU_SCRAMBLE = ModItems.registerFood("tofu_scramble", ModFoods.TOFU_SCRAMBLE, 1.0f);
    public static final RegistryObject<Item> TURNIP_BEETROOT_GRATIN = ModItems.registerFood("turnip_beetroot_gratin", ModFoods.TURNIP_BEETROOT_GRATIN, 1.0f);
    public static final RegistryObject<Item> BAKED_SWEET_POTATO = ModItems.registerFood("baked_sweet_potato", ModFoods.BAKED_SWEET_POTATO, 0.85f);
    public static final RegistryObject<Item> BAKED_YAM = ModItems.registerFood("baked_yam", Foods.f_38811_, 0.85f);
    public static final RegistryObject<Item> CHICKEN_PARMESAN = ModItems.registerFood("chicken_parmesan", ModFoods.CHICKEN_PARMESAN);
    public static final RegistryObject<Item> EGGPLANT_PARMESAN = ModItems.registerFood("eggplant_parmesan", ModFoods.EGGPLANT_PARMESAN, 1.0f);
    public static final RegistryObject<Item> FISH_FILLET = ModItems.registerFood("fish_fillet", ModFoods.FISH_FILLET);
    public static final RegistryObject<Item> GOLDEN_HABANERO = ModItems.registerGoldenHabanero("golden_habanero", ModFoods.GOLDEN_HABANERO);
    public static final RegistryObject<Item> LASAGNA = ModItems.registerFood("lasagna", ModFoods.LASAGNA);
    public static final RegistryObject<Item> PANCAKES = ModItems.registerFood("pancakes", ModFoods.PANCAKES, 1.0f);
    public static final RegistryObject<Item> PICKLE = ModItems.registerFood("pickle", ModFoods.PICKLE, 1.0f);
    public static final RegistryObject<Item> PICKLED_BEETROOT = ModItems.registerFood("pickled_beetroot", ModFoods.PICKLED_BEETROOT, 1.0f);
    public static final RegistryObject<Item> PIZZA = ModItems.registerFood("pizza", ModFoods.PIZZA, 1.0f);
    public static final RegistryObject<Item> POPCORN = ModItems.registerFood("popcorn", ModFoods.POPCORN, 1.0f);
    public static final RegistryObject<Item> POTATO_KNISH = ModItems.registerFood("potato_knish", ModFoods.POTATO_KNISH, 1.0f);
    public static final RegistryObject<Item> RAISINS = ModItems.registerFood("raisins", ModFoods.RAISINS, 1.0f);
    public static final RegistryObject<Item> STUFFED_CORN_ZUCCHINI = ModItems.registerFood("stuffed_corn_zucchini", ModFoods.STUFFED_CORN_ZUCCHINI, 1.0f);
    public static final RegistryObject<Item> SUSHI = ModItems.registerFood("sushi", ModFoods.SUSHI);
    public static final RegistryObject<Item> SWEET_POTATO_QUINOA_CAKES = ModItems.registerFood("sweet_potato_quinoa_cakes", ModFoods.SWEET_POTATO_QUINOA_CAKES, 1.0f);
    public static final RegistryObject<Item> TOFU = ModItems.registerFood("tofu", ModFoods.TOFU, 0.85f);
    public static final RegistryObject<Item> TRAIL_MIX = ModItems.registerFood("trail_mix", ModFoods.TRAIL_MIX, 1.0f);
    public static final RegistryObject<Item> CANDY = ModItems.registerFood("candy", ModFoods.CANDY, 1.0f);
    public static final RegistryObject<Item> CANDY_CANE = ModItems.registerFood("candy_cane", ModFoods.CANDY_CANE, 1.0f);
    public static final RegistryObject<Item> CASSAVA_CAKE = ModItems.registerFood("cassava_cake", ModFoods.CASSAVA_CAKE, 1.0f);
    public static final RegistryObject<Item> CHOCOLATE = ModItems.registerFood("chocolate", ModFoods.CHOCOLATE, 1.0f);
    public static final RegistryObject<Item> ICE_CREAM_SUNDAE = ModItems.registerFood("ice_cream_sundae", ModFoods.ICE_CREAM_SUNDAE, 1.0f);
    public static final RegistryObject<Item> JAFFA_CAKE = ModItems.registerFood("jaffa_cake", ModFoods.JAFFA_CAKE, 1.0f);
    public static final RegistryObject<Item> MARSHMALLOW = ModItems.registerFood("marshmallow", ModFoods.MARSHMALLOW, 1.0f);
    public static final RegistryObject<Item> PEANUT_BUTTER_COOKIE = ModItems.registerFood("peanut_butter_cookie", ModFoods.PEANUT_BUTTER_COOKIE, 1.0f);

    private static RegistryObject<Item> registerItem(String name) {
        RegistryObject ITEM = ITEMS.register(name, () -> new Item(new Item.Properties()));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerItem(String name, float compostChance) {
        RegistryObject<Item> ITEM = ModItems.registerItem(name);
        COMPOSTABLES.put(ITEM, Float.valueOf(compostChance));
        return ITEM;
    }

    private static RegistryObject<Item> registerFood(String name, FoodProperties pFood) {
        RegistryObject ITEM = ITEMS.register(name, () -> new Item(new Item.Properties().m_41489_(pFood)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerFood(String name, FoodProperties pFood, float compostChance) {
        RegistryObject<Item> ITEM = ModItems.registerFood(name, pFood);
        COMPOSTABLES.put(ITEM, Float.valueOf(compostChance));
        return ITEM;
    }

    private static RegistryObject<Item> registerGoldenHabanero(String name, FoodProperties pFood) {
        RegistryObject ITEM = ITEMS.register(name, () -> new Item(new Item.Properties().m_41497_(Rarity.RARE).m_41489_(pFood)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerBowlFood(String name, FoodProperties pFood) {
        RegistryObject ITEM = ITEMS.register(name, () -> new BowlFoodItem(new Item.Properties().m_41487_(1).m_41489_(pFood)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerSeed(String name, Supplier<Block> crop) {
        RegistryObject ITEM = ITEMS.register(name, () -> new SeedItem((Block)crop.get(), new Item.Properties()));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        COMPOSTABLES.put((RegistryObject<Item>)ITEM, Float.valueOf(0.3f));
        SEEDS.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerEdibleSeed(String name, Supplier<Block> flower) {
        RegistryObject ITEM = ITEMS.register(name, () -> new ItemNameBlockItem((Block)flower.get(), new Item.Properties().m_41489_(ModFoods.SEEDS)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        COMPOSTABLES.put((RegistryObject<Item>)ITEM, Float.valueOf(0.3f));
        return ITEM;
    }

    private static RegistryObject<Item> registerGrainCropItem(String name) {
        RegistryObject ITEM = ITEMS.register(name, () -> new GrainCropItem(new Item.Properties()));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        COMPOSTABLES.put((RegistryObject<Item>)ITEM, Float.valueOf(0.65f));
        return ITEM;
    }

    private static RegistryObject<Item> registerGrainCropItem(String name, FoodProperties pFood) {
        RegistryObject ITEM = ITEMS.register(name, () -> new GrainCropItem(new Item.Properties().m_41489_(pFood)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        COMPOSTABLES.put((RegistryObject<Item>)ITEM, Float.valueOf(0.65f));
        return ITEM;
    }

    private static RegistryObject<Item> registerRootCropItem(String name, FoodProperties pFood) {
        RegistryObject ITEM = ITEMS.register(name, () -> new RootCropItem(new Item.Properties().m_41489_(pFood)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        COMPOSTABLES.put((RegistryObject<Item>)ITEM, Float.valueOf(0.65f));
        return ITEM;
    }

    private static RegistryObject<Item> registerBlockItem(String name, Supplier<Block> block) {
        RegistryObject ITEM = ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerBlockItem(String name, Supplier<Block> block, float compostChance) {
        RegistryObject<Item> ITEM = ModItems.registerBlockItem(name, block);
        COMPOSTABLES.put(ITEM, Float.valueOf(compostChance));
        return ITEM;
    }

    private static RegistryObject<Item> registerCakeLike(String name, Supplier<Block> block) {
        RegistryObject ITEM = ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41487_(1)));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        COMPOSTABLES.put((RegistryObject<Item>)ITEM, Float.valueOf(1.0f));
        return ITEM;
    }

    private static RegistryObject<Item> registerAlcohol(String name, MobEffect effect) {
        RegistryObject ITEM = ITEMS.register(name, () -> new AlcoholItem(new Item.Properties().m_41487_(1), effect));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerScythe(String name, Tier tier) {
        RegistryObject ITEM = ITEMS.register(name, () -> new ScytheItem(tier, 2.0f, -3.0f, new Item.Properties()));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerMusicDisc(String name, int tickLength) {
        RegistryObject ITEM = ITEMS.register(name, () -> new RecordItem(15, () -> (SoundEvent)ModSoundEvents.MUSIC_DISC_NOURISH.get(), new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), tickLength));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }

    private static RegistryObject<Item> registerSeedPacket(String name, SeedPacketItem.Type type) {
        RegistryObject ITEM = ITEMS.register(name, () -> new SeedPacketItem(new Item.Properties(), type));
        ITEM_LIST.add((RegistryObject<Item>)ITEM);
        return ITEM;
    }
}

