/*
 * Decompiled with CFR 0.152.
 */
package dev.enemeez.simplefarming.common.item;

import dev.enemeez.simplefarming.common.registries.ModItems;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SeedPacketItem
extends Item {
    private static final Set<Supplier<Item>> FIBER_SEEDS = Set.of(ModItems.COTTON_SEEDS, ModItems.KENAF_SEEDS);
    private static final Set<Supplier<Item>> FRUIT_SEEDS = Set.of(ModItems.GRAPE_SEEDS, ModItems.TOMATO_SEEDS, ModItems.CUCUMBER_SEEDS, ModItems.EGGPLANT_SEEDS, ModItems.ZUCCHINI_SEEDS, ModItems.PEPPER_SEEDS);
    private static final Set<Supplier<Item>> GOURD_SEEDS = Set.of(() -> Items.f_42578_, () -> Items.f_42577_, ModItems.CANTALOUPE_SEEDS, ModItems.HONEYDEW_SEEDS, ModItems.SQUASH_SEEDS);
    private static final Set<Supplier<Item>> GRAIN_SEEDS = Set.of(() -> Items.f_42404_, ModItems.BARLEY_SEEDS, ModItems.OAT_SEEDS, ModItems.RYE_SEEDS, ModItems.RICE_SEEDS, ModItems.CORN_SEEDS, ModItems.SORGHUM_SEEDS);
    private static final Set<Supplier<Item>> LEAFY_SEEDS = Set.of(ModItems.BROCCOLI_SEEDS, ModItems.LETTUCE_SEEDS, ModItems.SPINACH_SEEDS);
    private static final Set<Supplier<Item>> LEGUME_SEEDS = Set.of(ModItems.SOYBEAN_SEEDS, ModItems.PEA_SEEDS, ModItems.PEANUT_SEEDS);
    private static final Set<Supplier<Item>> ROOT_SEEDS = Set.of(() -> Items.f_42733_, ModItems.RADISH_SEEDS, ModItems.TURNIP_SEEDS, ModItems.ONION_SEEDS, ModItems.GINGER_SEEDS);
    private static final Set<Supplier<Item>> TUBER_SEEDS = Set.of(ModItems.YAM_SEEDS, ModItems.SWEET_POTATO_SEEDS, ModItems.CASSAVA_SEEDS);
    private final Type TYPE;

    public SeedPacketItem(Item.Properties pProperties, Type type) {
        super(pProperties);
        this.TYPE = type;
    }

    private Item getRandomSeed(RandomSource rand, Set<Supplier<Item>> seeds) {
        return (Item)((Supplier)seeds.stream().skip(rand.m_188503_(seeds.size())).findFirst().get()).get();
    }

    private Set<Supplier<Item>> getContents() {
        return switch (this.TYPE) {
            default -> throw new IncompatibleClassChangeError();
            case Type.FIBER -> FIBER_SEEDS;
            case Type.FRUIT -> FRUIT_SEEDS;
            case Type.GOURD -> GOURD_SEEDS;
            case Type.GRAIN -> GRAIN_SEEDS;
            case Type.LEAFY -> LEAFY_SEEDS;
            case Type.LEGUME -> LEGUME_SEEDS;
            case Type.ROOT -> ROOT_SEEDS;
            case Type.TUBER -> TUBER_SEEDS;
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (!pLevel.f_46443_) {
            Set<Supplier<Item>> packet = this.getContents();
            int amount = pLevel.f_46441_.m_216339_(2, 4);
            for (int i = 0; i < amount; ++i) {
                ItemStack seed = new ItemStack((ItemLike)this.getRandomSeed(pLevel.f_46441_, packet));
                if (pPlayer.m_150109_().m_36054_(seed)) continue;
                pPlayer.m_36176_(seed, false);
            }
        }
        if (!pPlayer.m_150110_().f_35937_) {
            pPlayer.m_21120_(pHand).m_41774_(1);
        }
        pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11752_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.f_46441_.m_188501_() * 0.4f + 0.8f));
        return super.m_7203_(pLevel, pPlayer, pHand);
    }

    public static enum Type {
        FIBER,
        FRUIT,
        GOURD,
        GRAIN,
        LEAFY,
        LEGUME,
        ROOT,
        TUBER;

    }
}

