/*
 * Decompiled with CFR 0.152.
 */
package dev.enemeez.simplefarming.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import dev.enemeez.simplefarming.common.block.SprinkleCakeBlock;
import dev.enemeez.simplefarming.common.registries.ModBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SprinkleCandleCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Map<Block, SprinkleCandleCakeBlock> BY_CANDLE = Maps.newHashMap();
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));

    public SprinkleCandleCakeBlock(Block pCandleBlock, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        BY_CANDLE.put(pCandleBlock, this);
    }

    protected Iterable<Vec3> m_142199_(BlockState pState) {
        return PARTICLE_OFFSETS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
            if (SprinkleCandleCakeBlock.candleHit(pHit) && pPlayer.m_21120_(pHand).m_41619_() && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
                SprinkleCandleCakeBlock.m_151899_((Player)pPlayer, (BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            InteractionResult interactionresult = SprinkleCakeBlock.eat((LevelAccessor)pLevel, pPos, ((Block)ModBlocks.SPRINKLE_CAKE.get()).m_49966_(), pPlayer);
            if (interactionresult.m_19077_()) {
                SprinkleCandleCakeBlock.m_49950_((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
            }
            return interactionresult;
        }
        pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, pLevel.m_213780_().m_188501_() * 0.4f + 0.8f);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157792_, pPos);
        pPlayer.m_21120_(pHand).m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    private static boolean candleHit(BlockHitResult pHit) {
        return pHit.m_82450_().f_82480_ - (double)pHit.m_82425_().m_123342_() > 0.5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT});
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)Blocks.f_50145_);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return pDirection == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_280296_();
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return CakeBlock.f_152743_;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public static BlockState byCandle(Block pCandleBlock) {
        return BY_CANDLE.get(pCandleBlock).m_49966_();
    }

    public static boolean canLight(BlockState pState) {
        return pState.m_204338_(BlockTags.f_144268_, p_152896_ -> p_152896_.m_61138_((Property)LIT) && (Boolean)pState.m_61143_((Property)LIT) == false);
    }
}

