/*
 * Decompiled with CFR 0.152.
 */
package dev.enemeez.simplefarming.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import dev.enemeez.simplefarming.common.block.GourdStemBlock;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GourdAttachedStemBlock
extends BushBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (Object)Direction.NORTH, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)));
    private final Supplier<Item> SEED;
    private final Supplier<Block> FRUIT;
    private final Supplier<Block> STEM;

    public GourdAttachedStemBlock(BlockBehaviour.Properties pProperties, Supplier<Item> pSeedSupplier, Supplier<Block> fruit, Supplier<Block> stem) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.SEED = pSeedSupplier;
        this.FRUIT = fruit;
        this.STEM = stem;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABBS.get(pState.m_61143_((Property)FACING));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pFacingState.m_60713_(this.getFruit()) && pFacing == pState.m_61143_((Property)FACING) ? (BlockState)this.getStem().m_49966_().m_61124_((Property)GourdStemBlock.AGE, (Comparable)Integer.valueOf(7)) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_(Blocks.f_50093_);
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this.SEED.get());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    private Block getFruit() {
        return this.FRUIT.get();
    }

    private GourdStemBlock getStem() {
        return (GourdStemBlock)this.STEM.get();
    }
}

