/*
 * Decompiled with CFR 0.152.
 */
package dev.enemeez.simplefarming.client.integration;

import dev.enemeez.simplefarming.client.gui.FermenterScreen;
import dev.enemeez.simplefarming.common.block.menu.FermenterMenu;
import dev.enemeez.simplefarming.common.item.crafting.FermenterRecipe;
import dev.enemeez.simplefarming.common.registries.ModItems;
import dev.enemeez.simplefarming.common.registries.ModMenus;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JeiIntegration
implements IModPlugin {
    private static final RecipeType<FermenterRecipe> FERMENTER_RECIPE_TYPE = RecipeType.create((String)"simplefarming", (String)"fermenting", FermenterRecipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("simplefarming", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FermenterCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List fermenterRecipies = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)FermenterRecipe.Type.INSTANCE);
        registration.addRecipes(FERMENTER_RECIPE_TYPE, fermenterRecipies);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.FERMENTER.get()), new RecipeType[]{FERMENTER_RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(FermenterMenu.class, (MenuType)ModMenus.FERMENTER_MENU.get(), FERMENTER_RECIPE_TYPE, 36, 2, 0, 36);
    }

    private static class FermenterCategory
    implements IRecipeCategory<FermenterRecipe> {
        private final IDrawableAnimated arrow;
        private final IDrawable background;
        private final IDrawable icon;

        public FermenterCategory(IGuiHelper guiHelper) {
            this.arrow = guiHelper.drawableBuilder(FermenterScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(2000, IDrawableAnimated.StartDirection.LEFT, false);
            this.background = guiHelper.createDrawable(FermenterScreen.TEXTURE, 51, 12, 90, 62);
            this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModItems.FERMENTER.get()));
        }

        public RecipeType<FermenterRecipe> getRecipeType() {
            return FERMENTER_RECIPE_TYPE;
        }

        public Component getTitle() {
            return Component.m_237115_((String)"container.fermenter");
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FermenterRecipe recipe, IFocusGroup focuses) {
            NonNullList<Ingredient> ingredients = recipe.m_7527_();
            builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addIngredients((Ingredient)ingredients.get(0));
            builder.addSlot(RecipeIngredientRole.INPUT, 5, 41).addIngredients((Ingredient)ingredients.get(1));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 23).addItemStack(recipe.m_8043_(null));
        }

        public void draw(FermenterRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
            this.arrow.draw(guiGraphics, 28, 23);
        }
    }
}

