/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib;

import com.cursee.monolib.MonoLib;
import com.cursee.monolib.MonoLibClientForge;
import com.cursee.monolib.core.command.MonoLibCommands;
import com.cursee.monolib.core.command.hand.HandArgument;
import com.cursee.monolib.core.registry.ModRegistryForge;
import com.cursee.monolib.core.sailing.Sailing;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.Registries;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="monolib")
public class MonoLibForge {
    public static IEventBus EVENT_BUS;

    public MonoLibForge(FMLJavaModLoadingContext context) {
        MonoLib.init();
        EVENT_BUS = context.getModEventBus();
        ModRegistryForge.register(EVENT_BUS);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            new MonoLibClientForge(EVENT_BUS);
        }
        MonoLibForge.createEventListeners(EVENT_BUS);
    }

    private static void createEventListeners(IEventBus modEventBus) {
        MinecraftForge.EVENT_BUS.addListener(event -> Sailing.onEntityJoinLevel(event.getEntity(), event.getLevel()));
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256982_)) {
                event.register(Registries.f_256982_, MonoLib.identifier("item_output"), () -> ArgumentTypeInfos.registerByClass(HandArgument.class, HandArgument.SERIALIZER));
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> MonoLibCommands.defineCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection()));
    }

    public MonoLibForge() {
        this(FMLJavaModLoadingContext.get());
    }
}

