/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.UUID;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class SerializerUUID
implements ISerializer<UUID> {
    public static final ISerializer<UUID> SERIALIZER = new SerializerUUID();

    private SerializerUUID() {
    }

    @Override
    public UUID fromJSON(JsonElement json) {
        return UUID.fromString(json.getAsString());
    }

    @Override
    public JsonElement toJSON(UUID toWrite) {
        return new JsonPrimitive(toWrite.toString());
    }

    @Override
    public UUID fromByteBuf(FriendlyByteBuf buffer) {
        return UUID.fromString(buffer.m_130277_());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, UUID toWrite) {
        buffer.m_130070_(toWrite.toString());
    }

    @Override
    public Tag toNBT(UUID toWrite) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", toWrite);
        return tag;
    }

    @Override
    public UUID fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            return compound.m_128342_("id");
        }
        throw new NBTParseException("Expected NBT to be a compund tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

