/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class EmbellishmentModifier
extends NoLevelsModifier
implements ModifierRemovalHook,
RawDataModifierHook {
    private static final String FORMAT_KEY = TConstruct.makeTranslationKey("modifier", "embellishment.formatted");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.REMOVE, ModifierHooks.RAW_DATA);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        MaterialVariantId materialVariant = MaterialVariantId.tryParse(tool.getPersistentData().getString(this.getId()));
        if (materialVariant != null) {
            return Component.m_237110_((String)FORMAT_KEY, (Object[])new Object[]{MaterialTooltipCache.getDisplayName(materialVariant)}).m_130938_(style -> style.m_131148_(MaterialTooltipCache.getColor(materialVariant)));
        }
        return super.getDisplayName();
    }

    @Override
    public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
        ModifierId key;
        ModDataNBT data = tool.getPersistentData();
        MaterialVariantId materialVariant = MaterialVariantId.tryParse(data.getString(key = this.getId()));
        if (materialVariant != null) {
            MaterialId original = materialVariant.getId();
            MaterialId resolved = MaterialRegistry.getInstance().resolve(original);
            if (resolved != original) {
                data.putString(key, MaterialVariantId.create(resolved, materialVariant.getVariant()).toString());
            }
        }
    }

    @Override
    public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(this.getId());
        return null;
    }
}

