/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class EntityModifierCapability {
    public static final EntityModifiers EMPTY = new EntityModifiers(){

        @Override
        public ModifierNBT getModifiers() {
            return ModifierNBT.EMPTY;
        }

        @Override
        public void setModifiers(ModifierNBT nbt) {
        }
    };
    private static final List<Predicate<Entity>> ENTITY_PREDICATES = new ArrayList<Predicate<Entity>>();
    private static final ResourceLocation ID = TConstruct.getResource("modifiers");
    public static final Capability<EntityModifiers> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityModifiers>(){});

    private EntityModifierCapability() {
    }

    public static ModifierNBT getOrEmpty(Entity entity) {
        return ((EntityModifiers)entity.getCapability(CAPABILITY).orElse((Object)EMPTY)).getModifiers();
    }

    public static boolean supportCapability(Entity entity) {
        for (Predicate<Entity> entityPredicate : ENTITY_PREDICATES) {
            if (!entityPredicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    public static void registerEntityPredicate(Predicate<Entity> predicate) {
        ENTITY_PREDICATES.add(predicate);
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, event -> event.register(ModifierNBT.class));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, EntityModifierCapability::attachCapability);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (EntityModifierCapability.supportCapability((Entity)event.getObject())) {
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    public static interface EntityModifiers {
        public ModifierNBT getModifiers();

        public void setModifiers(ModifierNBT var1);
    }

    private static class Provider
    implements ICapabilitySerializable<ListTag>,
    Runnable,
    EntityModifiers {
        private ModifierNBT modifiers = ModifierNBT.EMPTY;
        private LazyOptional<EntityModifiers> capability = LazyOptional.of(() -> this);

        private Provider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.capability);
        }

        @Override
        public void run() {
            this.capability.invalidate();
            this.capability = LazyOptional.of(() -> this);
        }

        public ListTag serializeNBT() {
            return this.modifiers.serializeToNBT();
        }

        public void deserializeNBT(ListTag nbt) {
            this.modifiers = ModifierNBT.readFromNBT((Tag)nbt);
            this.run();
        }

        @Override
        public ModifierNBT getModifiers() {
            return this.modifiers;
        }

        @Override
        public void setModifiers(ModifierNBT modifiers) {
            this.modifiers = modifiers;
        }
    }
}

