/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.general;

import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;
import slimeknights.tconstruct.library.modifiers.fluid.GroupCost;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;

public record AreaMobEffectFluidEffect(FluidMobEffect effect, TimeAction action, GroupCost groupCost) implements FluidEffect<FluidEffectContext>
{
    public static final RecordLoadable<AreaMobEffectFluidEffect> LOADER = RecordLoadable.create((RecordField)FluidMobEffect.LOADABLE.directField(e -> e.effect), (RecordField)TimeAction.LOADABLE.requiredField("action", e -> e.action), (RecordField)GroupCost.LOADABLE.requiredField("group_cost", e -> e.groupCost), AreaMobEffectFluidEffect::new);

    @Override
    public RecordLoadable<? extends FluidEffect<FluidEffectContext>> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext context, IFluidHandler.FluidAction action) {
        float used = 0.0f;
        for (LivingEntity living : context.getLevel().m_45976_(LivingEntity.class, new AABB(context.getBlockPos()))) {
            float localUsed = this.effect.apply(living, level, this.action, action);
            if (this.groupCost == GroupCost.SUM) {
                used += localUsed;
                level = level.subtract(localUsed);
                continue;
            }
            if (!(localUsed > used)) continue;
            used = localUsed;
        }
        return used;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return this.effect.getDisplayName(this.action);
    }
}

