/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.tconstruct.common.TinkerEffect;

public class FakeRegistryEntry {
    private static <T> T getOrCreate(IForgeRegistry<T> registry, ResourceLocation id, Supplier<T> constructor) {
        if (!registry.containsKey(id)) {
            ((ForgeRegistry)registry).unfreeze();
            T value = constructor.get();
            registry.register(id, value);
            return value;
        }
        return (T)Objects.requireNonNull(registry.getValue(id));
    }

    public static Block block(ResourceLocation id) {
        return FakeRegistryEntry.getOrCreate(ForgeRegistries.BLOCKS, id, () -> new Block(BlockBehaviour.Properties.m_284310_()));
    }

    public static MobEffect effect(ResourceLocation id) {
        return FakeRegistryEntry.getOrCreate(ForgeRegistries.MOB_EFFECTS, id, () -> new TinkerEffect(MobEffectCategory.NEUTRAL, false));
    }
}

