/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.amendments.events.behaviors.BellChainRing;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.events.behaviors.CarpetSlabConversion;
import net.mehvahdjukaar.amendments.events.behaviors.CarpetStairsConversion;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronDyeWater;
import net.mehvahdjukaar.amendments.events.behaviors.DirectionalCakeConversion;
import net.mehvahdjukaar.amendments.events.behaviors.DoubleCakeConversion;
import net.mehvahdjukaar.amendments.events.behaviors.DyeBehavior;
import net.mehvahdjukaar.amendments.events.behaviors.FireChargeShoot;
import net.mehvahdjukaar.amendments.events.behaviors.ItemUse;
import net.mehvahdjukaar.amendments.events.behaviors.ItemUseOnBlock;
import net.mehvahdjukaar.amendments.events.behaviors.SkullCandleConversion;
import net.mehvahdjukaar.amendments.events.behaviors.SkullPileConversion;
import net.mehvahdjukaar.amendments.events.behaviors.ToolHookConversion;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.FlanCompat;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class InteractEvents {
    private static final Map<Item, ItemUseOnBlock> ITEM_USE_ON_BLOCK_HP = new IdentityHashMap<Item, ItemUseOnBlock>();
    private static final Multimap<Item, ItemUseOnBlock> ITEM_USE_ON_BLOCK = HashMultimap.create();
    private static final Map<Item, ItemUse> ITEM_USE = new IdentityHashMap<Item, ItemUse>();
    private static final Map<Block, BlockUse> BLOCK_USE = new IdentityHashMap<Block, BlockUse>();

    public static boolean hasBlockPlacementAssociated(Item item) {
        return false;
    }

    public static void setupOverrides() {
        ITEM_USE.clear();
        ITEM_USE_ON_BLOCK_HP.clear();
        ITEM_USE_ON_BLOCK.clear();
        BLOCK_USE.clear();
        ArrayList<ItemUseOnBlock> itemUseOnBlockHP = new ArrayList<ItemUseOnBlock>();
        ArrayList<ItemUseOnBlock> itemUseOnBlock = new ArrayList<ItemUseOnBlock>();
        ArrayList<FireChargeShoot> itemUseLP = new ArrayList<FireChargeShoot>();
        ArrayList<BlockUse> blockUse = new ArrayList<BlockUse>();
        itemUseLP.add(new FireChargeShoot());
        blockUse.add(new DirectionalCakeConversion());
        blockUse.add(new BellChainRing());
        blockUse.add(new CauldronDyeWater());
        blockUse.add(new ToolHookConversion());
        itemUseOnBlockHP.add(new SkullCandleConversion());
        itemUseOnBlockHP.add(new DyeBehavior());
        itemUseOnBlock.add(new SkullPileConversion());
        itemUseOnBlock.add(new DoubleCakeConversion());
        itemUseOnBlock.add(new CarpetStairsConversion());
        itemUseOnBlock.add(new CarpetSlabConversion());
        block0: for (Item i : BuiltInRegistries.f_257033_) {
            for (ItemUseOnBlock itemUseOnBlock2 : itemUseOnBlock) {
                if (!itemUseOnBlock2.appliesToItem(i)) continue;
                ITEM_USE_ON_BLOCK.put((Object)i, (Object)itemUseOnBlock2);
            }
            for (ItemUse itemUse : itemUseLP) {
                if (!itemUse.appliesToItem(i)) continue;
                ITEM_USE.put(i, itemUse);
                continue block0;
            }
            for (ItemUseOnBlock itemUseOnBlock3 : itemUseOnBlockHP) {
                if (!itemUseOnBlock3.appliesToItem(i)) continue;
                ITEM_USE_ON_BLOCK_HP.put(i, itemUseOnBlock3);
                continue block0;
            }
        }
        block4: for (Block block : BuiltInRegistries.f_256975_) {
            for (BlockUse blockUse2 : blockUse) {
                if (!blockUse2.appliesToBlock(block)) continue;
                BLOCK_USE.put(block, blockUse2);
                continue block4;
            }
        }
    }

    public static InteractionResult onItemUsedOnBlockHP(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.m_41720_();
        ItemUseOnBlock override = ITEM_USE_ON_BLOCK_HP.get(item);
        if (override != null && override.isEnabled()) {
            if (CompatHandler.FLAN && override.altersWorld() && !FlanCompat.canPlace(player, hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            if (override.altersWorld() && !Utils.mayPerformBlockAction((Player)player, (BlockPos)hit.m_82425_(), (ItemStack)stack)) {
                return InteractionResult.PASS;
            }
            return override.tryPerformingAction(level, player, hand, stack, hit);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onItemUsedOnBlock(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.m_41720_();
        for (ItemUseOnBlock override : ITEM_USE_ON_BLOCK.get((Object)item)) {
            if (override == null || !override.isEnabled()) continue;
            if (CompatHandler.FLAN && override.altersWorld() && !FlanCompat.canPlace(player, hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            if (override.altersWorld() && !Utils.mayPerformBlockAction((Player)player, (BlockPos)hit.m_82425_(), (ItemStack)stack)) {
                return InteractionResult.PASS;
            }
            InteractionResult result = override.tryPerformingAction(level, player, hand, stack, hit);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        BlockPos pos = hit.m_82425_();
        BlockState state = level.m_8055_(pos);
        BlockUse o = BLOCK_USE.get(state.m_60734_());
        if (o != null && o.isEnabled()) {
            if (CompatHandler.FLAN && o.altersWorld() && !FlanCompat.canPlace(player, hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            return o.tryPerformingAction(state, pos, level, player, hand, stack, hit);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> onItemUseLP(Player player, Level level, InteractionHand hand, ItemStack stack) {
        Item item = stack.m_41720_();
        ItemUse override = ITEM_USE.get(item);
        if (override != null && override.isEnabled()) {
            InteractionResult ret = override.tryPerformingAction(level, player, hand, stack, null);
            return switch (ret) {
                case InteractionResult.CONSUME -> InteractionResultHolder.m_19096_((Object)stack);
                case InteractionResult.SUCCESS -> InteractionResultHolder.m_19090_((Object)stack);
                case InteractionResult.FAIL -> InteractionResultHolder.m_19100_((Object)stack);
                default -> InteractionResultHolder.m_19098_((Object)stack);
            };
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static InteractionResult replaceSimilarBlock(Block blockOverride, Player player, ItemStack stack, BlockPos pos, Level level, BlockState replaced, @Nullable SoundType sound, boolean keepWater, boolean playEvent, Property<?> ... properties) {
        BlockState newState = blockOverride.m_49966_();
        for (Property<?> p : properties) {
            newState = Utils.replaceProperty((BlockState)replaced, (BlockState)newState, p);
        }
        if (newState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            FluidState fluidstate = level.m_6425_(pos);
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(keepWater && fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
        }
        if (!level.m_7731_(pos, newState, 3)) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10591_.m_285767_(serverPlayer, pos, stack);
        }
        if (playEvent) {
            level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        }
        if (sound == null) {
            sound = newState.m_60827_();
        }
        level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

