/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.util.mixin;

import com.cerbon.better_beacons.BetterBeacons;
import com.cerbon.better_beacons.advancement.BBCriteriaTriggers;
import com.cerbon.better_beacons.mixin.accessor.BeaconBeamSectionAccessor;
import com.cerbon.better_beacons.mixin.accessor.BeaconBlockEntityAccessor;
import com.cerbon.better_beacons.util.BBConstants;
import com.cerbon.better_beacons.util.BBUtils;
import com.cerbon.cerbons_api.api.static_utilities.MiscUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;

public class BeaconRedirectionAndTransparency {
    public static int horizontalMoveLimit = BetterBeacons.config.beaconBeam.horizontalMoveLimit;
    public static boolean allowRedirecting = BetterBeacons.config.beaconBeam.allowRedirecting;
    public static boolean allowTintedGlassTransparency = BetterBeacons.config.beaconBeam.allowTransparency;

    public static int tickBeacon(BeaconBlockEntity beacon) {
        BlockPos beaconPos;
        BeaconBlockEntityAccessor beaconAccessor = (BeaconBlockEntityAccessor)beacon;
        Level level = beacon.m_58904_();
        BlockPos currPos = beaconPos = beacon.m_58899_();
        int i = beaconPos.m_123341_();
        int j = beaconPos.m_123342_();
        int k = beaconPos.m_123343_();
        int horizontalMoves = horizontalMoveLimit;
        int targetHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE, beaconPos.m_123341_(), beaconPos.m_123343_());
        boolean broke = false;
        boolean didRedirection = false;
        beaconAccessor.checkingBeamSections().clear();
        float[] currColor = new float[]{1.0f, 1.0f, 1.0f};
        float alpha = 1.0f;
        Direction lastDir = null;
        ExtendedBeamSegment currSegment = new ExtendedBeamSegment(Direction.UP, Vec3i.f_123288_, currColor, alpha);
        HashSet<BlockPos> seenPositions = new HashSet<BlockPos>();
        boolean hardColorSet = false;
        while (level.m_46739_(currPos) && horizontalMoves > 0) {
            boolean added;
            if (currSegment.dir == Direction.UP && currSegment.dir != lastDir) {
                int heightmapVal = level.m_6924_(Heightmap.Types.WORLD_SURFACE, currPos.m_123341_(), currPos.m_123343_());
                if (heightmapVal == currPos.m_123342_() + 1) {
                    ((BeaconBeamSectionAccessor)((Object)currSegment)).setHeight(heightmapVal + 1000);
                    break;
                }
                lastDir = currSegment.dir;
            }
            currPos = currPos.m_121945_(currSegment.dir);
            horizontalMoves = currSegment.dir.m_122434_().m_122479_() ? --horizontalMoves : horizontalMoveLimit;
            BlockState blockstate = level.m_8055_(currPos);
            Block block = blockstate.m_60734_();
            float[] targetColor = BeaconRedirectionAndTransparency.getBeaconColorMultiplier(blockstate);
            float targetAlpha = -1.0f;
            if (allowTintedGlassTransparency && block.m_49966_().m_204336_(BBConstants.BEACON_TRANSPARENCY)) {
                float f = targetAlpha = alpha < 0.3f ? 0.0f : alpha / 2.0f;
                if (targetAlpha <= 0.0f) {
                    for (ServerPlayer serverplayer : BBUtils.getPlayersNearBeacon(beacon.m_58904_(), i, j, k)) {
                        BBCriteriaTriggers.INVISIBLE_BEAM.trigger(serverplayer);
                    }
                }
            }
            if (BeaconRedirectionAndTransparency.isRedirectingBlock(block) && allowRedirecting) {
                Direction dir = (Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61372_);
                if (dir == currSegment.dir) {
                    currSegment.m_58719_();
                } else {
                    beaconAccessor.checkingBeamSections().add(currSegment);
                    targetColor = BeaconRedirectionAndTransparency.getTargetColor(block);
                    if (targetColor[0] == 1.0f && targetColor[1] == 1.0f && targetColor[2] == 1.0f) {
                        targetColor = currColor;
                    }
                    currColor = new float[]{(currColor[0] + targetColor[0] * 3.0f) / 4.0f, (currColor[1] + targetColor[1] * 3.0f) / 4.0f, (currColor[2] + targetColor[2] * 3.0f) / 4.0f};
                    alpha = 1.0f;
                    didRedirection = true;
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(dir, (Vec3i)currPos.m_121996_((Vec3i)beaconPos), currColor, alpha);
                }
            } else if (targetColor != null || targetAlpha != -1.0f) {
                if (Arrays.equals(targetColor, currColor) && targetAlpha == alpha) {
                    currSegment.m_58719_();
                } else {
                    beaconAccessor.checkingBeamSections().add(currSegment);
                    float[] mixedColor = currColor;
                    if (targetColor != null) {
                        mixedColor = new float[]{(currColor[0] + targetColor[0]) / 2.0f, (currColor[1] + targetColor[1]) / 2.0f, (currColor[2] + targetColor[2]) / 2.0f};
                        if (!hardColorSet) {
                            mixedColor = targetColor;
                            hardColorSet = true;
                        }
                        currColor = mixedColor;
                    }
                    if (targetAlpha != -1.0f) {
                        alpha = targetAlpha;
                    }
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(currSegment.dir, (Vec3i)currPos.m_121996_((Vec3i)beaconPos), mixedColor, alpha);
                }
            } else {
                boolean bedrock = blockstate.m_204336_(BBConstants.BEACON_TRANSPARENT);
                if (!bedrock && blockstate.m_60739_((BlockGetter)level, currPos) >= 15) {
                    broke = true;
                    break;
                }
                currSegment.m_58719_();
                if (bedrock) continue;
            }
            if (added = seenPositions.add(currPos)) continue;
            broke = true;
            break;
        }
        if (horizontalMoves == 0 || currPos.m_123342_() <= level.m_141937_()) {
            broke = true;
        }
        String tag = "better_beacons:redirected";
        if (!broke) {
            beaconAccessor.checkingBeamSections().add(currSegment);
            beaconAccessor.setLastCheckY(targetHeight + 1);
        } else {
            beacon.m_5995_().m_128379_("better_beacons:redirected", false);
            beaconAccessor.checkingBeamSections().clear();
            beaconAccessor.setLastCheckY(targetHeight);
        }
        if (!beacon.m_5995_().m_128471_("better_beacons:redirected") && didRedirection && !beaconAccessor.checkingBeamSections().isEmpty()) {
            beacon.m_5995_().m_128379_("better_beacons:redirected", true);
            for (ServerPlayer serverplayer : BBUtils.getPlayersNearBeacon(beacon.m_58904_(), i, j, k)) {
                BBCriteriaTriggers.REDIRECT_BEACON.trigger(serverplayer);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isRedirectingBlock(Block block) {
        return block.m_49966_().m_204336_(BBConstants.BEACON_REDIRECT);
    }

    private static float[] getBeaconColorMultiplier(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof BeaconBeamBlock) {
            BeaconBeamBlock beaconBeamBlock = (BeaconBeamBlock)block;
            return beaconBeamBlock.m_7988_().m_41068_();
        }
        return null;
    }

    private static float[] getTargetColor(Block block) {
        if (MiscUtils.isModLoaded((String)"quark")) {
            try {
                Class<?> ccClass = Class.forName("org.violetmoon.quark.content.world.block.CorundumClusterBlock");
                if (ccClass.isInstance(block)) {
                    Field baseField = ccClass.getDeclaredField("base");
                    baseField.setAccessible(true);
                    Object base = baseField.get(block);
                    Field colorComponentsField = base.getClass().getDeclaredField("colorComponents");
                    colorComponentsField.setAccessible(true);
                    return (float[])colorComponentsField.get(base);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                BBConstants.LOGGER.error("Couldn't get target color for corundum cluster block", (Throwable)e);
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static class ExtendedBeamSegment
    extends BeaconBlockEntity.BeaconBeamSection {
        public final Direction dir;
        public final Vec3i offset;
        public final float alpha;

        public ExtendedBeamSegment(Direction dir, Vec3i offset, float[] colorsIn, float alpha) {
            super(colorsIn);
            this.offset = offset;
            this.dir = dir;
            this.alpha = alpha;
        }

        public void m_58719_() {
            super.m_58719_();
        }
    }
}

