/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.factory.GridBlockGridFactory;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.ColoredNetworkBlock;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class GridBlock
extends ColoredNetworkBlock {
    private final GridType type;

    public GridBlock(GridType type) {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.type = type;
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.HORIZONTAL;
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GridBlockEntity(this.type, pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = (switch (this.type) {
            case GridType.FLUID -> RSBlocks.FLUID_GRID;
            case GridType.NORMAL -> RSBlocks.GRID;
            case GridType.CRAFTING -> RSBlocks.CRAFTING_GRID;
            case GridType.PATTERN -> RSBlocks.PATTERN_GRID;
            default -> throw new IllegalStateException("Unexpected value: " + this.type);
        }).changeBlockColor(state, player.m_21120_(hand), level, pos, player);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (!level.f_46443_) {
            return NetworkUtils.attemptModify(level, pos, player, () -> API.instance().getGridManager().openGrid(GridBlockGridFactory.ID, (ServerPlayer)player, pos));
        }
        return InteractionResult.SUCCESS;
    }
}

