/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeFactory;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.util.RSSavedData;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkNodeManager
extends RSSavedData
implements INetworkNodeManager {
    public static final String NAME = "refinedstorage_nodes";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_NODE_ID = "Id";
    private static final String NBT_NODE_DATA = "Data";
    private static final String NBT_NODE_POS = "Pos";
    private final Level level;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ConcurrentHashMap<BlockPos, INetworkNode> nodes = new ConcurrentHashMap();

    public NetworkNodeManager(Level level) {
        this.level = level;
    }

    @Override
    public void load(CompoundTag tag) {
        if (tag.m_128441_(NBT_NODES)) {
            ListTag nodesTag = tag.m_128437_(NBT_NODES, 10);
            this.nodes.clear();
            for (int i = 0; i < nodesTag.size(); ++i) {
                CompoundTag nodeTag = nodesTag.m_128728_(i);
                ResourceLocation id = new ResourceLocation(nodeTag.m_128461_(NBT_NODE_ID));
                CompoundTag data = nodeTag.m_128469_(NBT_NODE_DATA);
                BlockPos pos = BlockPos.m_122022_((long)nodeTag.m_128454_(NBT_NODE_POS));
                INetworkNodeFactory factory = API.instance().getNetworkNodeRegistry().get(id);
                if (factory != null) {
                    INetworkNode node = null;
                    try {
                        node = factory.create(data, this.level, pos);
                    }
                    catch (Throwable t) {
                        this.logger.error("Could not read network node", t);
                    }
                    if (node == null) continue;
                    this.nodes.put(pos, node);
                    continue;
                }
                this.logger.warn("Factory for {} not found in network node registry", (Object)id);
            }
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (INetworkNode node : this.all()) {
            try {
                CompoundTag nodeTag = new CompoundTag();
                nodeTag.m_128359_(NBT_NODE_ID, node.getId().toString());
                nodeTag.m_128356_(NBT_NODE_POS, node.getPos().m_121878_());
                nodeTag.m_128365_(NBT_NODE_DATA, (Tag)node.write(new CompoundTag()));
                list.add((Object)nodeTag);
            }
            catch (Throwable t) {
                this.logger.error("Error while saving network node", t);
            }
        }
        tag.m_128365_(NBT_NODES, (Tag)list);
        return tag;
    }

    @Override
    @Nullable
    public INetworkNode getNode(BlockPos pos) {
        return this.nodes.get(pos);
    }

    @Override
    public void removeNode(BlockPos pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        this.nodes.remove(pos);
    }

    @Override
    public void setNode(BlockPos pos, INetworkNode node) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        this.nodes.put(pos, node);
    }

    @Override
    public Collection<INetworkNode> all() {
        return this.nodes.values();
    }

    @Override
    public void markForSaving() {
        this.m_77762_();
    }
}

