/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures.processors;

import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class WoolReplacingProcessor
extends StructureProcessor {
    private static final List<String> ALL_COLORS = Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_).toList();
    private static final Pattern PATTERN = Pattern.compile("minecraft:[a-z_]+_wool", 2);
    public static final Codec<WoolReplacingProcessor> CODEC = Codec.unit(WoolReplacingProcessor::new);
    private String color = null;

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos var2, BlockPos var3, StructureTemplate.StructureBlockInfo var4, StructureTemplate.StructureBlockInfo var5, StructurePlaceSettings settings) {
        RandomSource random = settings.m_230326_(var5.f_74675_());
        this.ensureColor(random);
        if (!this.isWoolBlock(var5.f_74676_())) {
            return var5;
        }
        BlockState replacement = this.getNewWool(this.color);
        if (replacement == null) {
            return var5;
        }
        return new StructureTemplate.StructureBlockInfo(var5.f_74675_(), replacement, var5.f_74677_());
    }

    private BlockState getNewWool(String color) {
        ResourceLocation location = new ResourceLocation(color + "_wool");
        if (BuiltInRegistries.f_256975_.m_7804_(location)) {
            return ((Block)BuiltInRegistries.f_256975_.m_7745_(location)).m_49966_();
        }
        return null;
    }

    private void ensureColor(RandomSource random) {
        if (this.color == null) {
            this.color = ALL_COLORS.get(random.m_188503_(ALL_COLORS.size()));
        }
    }

    private boolean isWoolBlock(BlockState state) {
        String block_id = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
        return PATTERN.matcher(block_id).find();
    }

    protected StructureProcessorType<?> m_6953_() {
        return ModRegistry.WOOL_REPLACING_PROCESSOR.get();
    }
}

