/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures.pieces;

import com.mojang.serialization.DynamicOps;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worldgen.structures.processors.DeepslateProcessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SlimeCaveStructurePiece
extends TemplateStructurePiece {
    private static final InclusiveRange<Integer> RANGE = new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7));
    private static Tag spawnDataTag = null;

    public SlimeCaveStructurePiece(StructureTemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation) {
        super(ModRegistry.SLIME_CAVE_PIECE.get(), 0, manager, location, location.toString(), SlimeCaveStructurePiece.makeSettings(rotation), pos);
        SlimeCaveStructurePiece.createSpawnData();
    }

    public SlimeCaveStructurePiece(StructureTemplateManager manager, CompoundTag tag) {
        super(ModRegistry.SLIME_CAVE_PIECE.get(), tag, manager, $$1x -> SlimeCaveStructurePiece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rot"))));
        SlimeCaveStructurePiece.createSpawnData();
    }

    public SlimeCaveStructurePiece(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        this(context.f_226956_(), compoundTag);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74383_((StructureProcessor)DeepslateProcessor.INSTANCE);
    }

    private static void createSpawnData() {
        if (spawnDataTag == null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("id", "minecraft:slime");
            SpawnData.CustomSpawnRules customSpawnRules = new SpawnData.CustomSpawnRules(RANGE, RANGE);
            SpawnData spawnData = new SpawnData(tag, Optional.of(customSpawnRules));
            spawnDataTag = (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)spawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"));
        }
    }

    protected void m_213704_(String marker, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox bb) {
        Slime slime;
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        if (marker.equals("spawner")) {
            level.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                CompoundTag oldData = spawner.m_59801_().m_186381_(new CompoundTag());
                oldData.m_128365_("SpawnData", spawnDataTag);
                spawner.m_59801_().m_151328_(null, pos, oldData);
                spawner.m_6596_();
                blockEntity.m_6596_();
            }
        } else if (marker.equals("slime") && (slime = (Slime)EntityType.f_20526_.m_20615_((Level)level.m_6018_())) != null) {
            slime.m_20035_(pos, 0.0f, 0.0f);
            slime.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            slime.m_7839_(random.m_188503_(3) + 1, true);
            level.m_7967_((Entity)slime);
        }
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rot", this.f_73657_.m_74404_().name());
    }
}

