/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.config;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.Explorations;
import com.tristankechlo.explorations.config.types.VillageType;
import com.tristankechlo.explorations.config.types.WeightedResourceLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public record ExplorationsConfig(Map<VillageType, List<WeightedResourceLocation>> statues) {
    public static final Codec<ExplorationsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(VillageType.CODEC, (Codec)WeightedResourceLocation.CODEC.listOf()).fieldOf("statues").forGetter(ExplorationsConfig::statues)).apply((Applicative)instance, ExplorationsConfig::new));
    public static final ExplorationsConfig DEFAULT;
    private static ExplorationsConfig INSTANCE;

    public static ExplorationsConfig get() {
        return INSTANCE;
    }

    public static void setToDefault() {
        INSTANCE = DEFAULT;
    }

    public static JsonElement toJson() {
        DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)INSTANCE);
        result.error().ifPresent(partial -> Explorations.LOGGER.error(partial.message()));
        return (JsonElement)result.result().orElseThrow();
    }

    public static void fromJson(JsonElement json) {
        DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        result.error().ifPresent(partial -> Explorations.LOGGER.error(partial.message()));
        INSTANCE = (ExplorationsConfig)result.result().orElseThrow();
    }

    private static Map<VillageType, List<WeightedResourceLocation>> makeStatues() {
        HashMap<VillageType, List<WeightedResourceLocation>> m = new HashMap<VillageType, List<WeightedResourceLocation>>();
        for (VillageType village : VillageType.NO_DESERT) {
            ArrayList<WeightedResourceLocation> l = new ArrayList<WeightedResourceLocation>();
            for (int i = 1; i <= 4; ++i) {
                l.add(new WeightedResourceLocation(ExplorationsConfig.statue(i), village.getDefaultWeight()));
            }
            m.put(village, l);
        }
        return m;
    }

    private static ResourceLocation statue(int i) {
        return new ResourceLocation("explorations", "statues/statue_" + i);
    }

    static {
        INSTANCE = DEFAULT = new ExplorationsConfig(ExplorationsConfig.makeStatues());
    }
}

