/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.util.json.validator;

import insane96mcp.insanelib.util.json.validator.Validator;

public class FloatMinMaxValidator
extends Validator<Float> {
    private final float min;
    private final float max;

    public FloatMinMaxValidator(float min, float max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(Float value) {
        return value.floatValue() >= this.min && value.floatValue() <= this.max;
    }

    @Override
    public String getErrorMessage(Float value) {
        return "Value %s must be between %s and %s".formatted(value, Float.valueOf(this.min), Float.valueOf(this.max));
    }

    public static FloatMinMaxValidator between(float min, float max) {
        return new FloatMinMaxValidator(min, max);
    }

    public static FloatMinMaxValidator atLeast(float min) {
        return new FloatMinMaxValidator(min, Float.MAX_VALUE);
    }

    public static FloatMinMaxValidator atMost(float max) {
        return new FloatMinMaxValidator(-3.4028235E38f, max);
    }
}

