/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="insanelib:base", description="Set and use some tags to set some mobs properties. E.g. cause fire explosion for mobs or know if a mob has been spawned from spawner.", canBeDisabled=false)
public class TagsFeature
extends Feature {
    public static ResourceLocation SPAWN_TYPE;
    public static ResourceLocation EXPLOSION_CAUSES_FIRE;
    public static ResourceLocation EXPERIENCE_MULTIPLIER;

    @Override
    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        SPAWN_TYPE = this.createDataKey("spawn_type");
        EXPLOSION_CAUSES_FIRE = this.createDataKey("explosion_causes_fire");
        EXPERIENCE_MULTIPLIER = this.createDataKey("xp_multiplier");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        Entity entity = explosion.getExploder();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (ModNBTData.get((Entity)entity2, EXPLOSION_CAUSES_FIRE, Boolean.class).booleanValue()) {
            explosion.f_46009_ = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpawn(MobSpawnEvent.FinalizeSpawn event) {
        ModNBTData.put((Entity)event.getEntity(), SPAWN_TYPE, (Object)((byte)event.getSpawnType().ordinal()));
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        if (ModNBTData.contains((Entity)event.getEntity(), EXPERIENCE_MULTIPLIER)) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * ModNBTData.get((Entity)event.getEntity(), EXPERIENCE_MULTIPLIER, Double.class)));
        }
    }

    public static boolean isSpawnType(MobSpawnType spawnType, LivingEntity entity) {
        return ModNBTData.get((Entity)entity, SPAWN_TYPE, Byte.class).byteValue() == spawnType.ordinal();
    }

    public static void setExplosionCausesFire(boolean causesFire, LivingEntity entity) {
        ModNBTData.put((Entity)entity, EXPLOSION_CAUSES_FIRE, (Object)causesFire);
    }

    public static void setExperienceMultiplier(double multiplier, LivingEntity entity) {
        ModNBTData.put((Entity)entity, EXPERIENCE_MULTIPLIER, (Object)multiplier);
    }
}

