/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.mixin;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.event.ILEventFactory;
import insane96mcp.insanelib.module.base.betterfallingblocks.BetterFallingBlockExtensor;
import insane96mcp.insanelib.module.base.betterfallingblocks.BetterFallingBlocks;
import insane96mcp.insanelib.util.LogHelper;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends Entity
implements BetterFallingBlockExtensor {
    @Unique
    private static final double GRAVITY_ACCELERATION = 0.04;
    @Unique
    private static final double HORIZONTAL_DRAG = 0.7;
    @Unique
    private static final double VERTICAL_BOUNCE = -0.5;
    @Unique
    private static final double AIR_RESISTANCE = 0.98;
    @Unique
    private static final int MAX_TIME_OUTSIDE_WORLD = 100;
    @Unique
    private static final int ABSOLUTE_MAX_TIME = 600;
    @Unique
    private static final int MAX_STACK_HEIGHT = 3;
    @Unique
    private static final double CONCRETE_POWDER_VELOCITY_THRESHOLD = 1.0;
    @Unique
    private Entity insanelib$source;
    @Unique
    public Direction insanelib$directionFalling;
    @Unique
    public Direction insanelib$movedFrom;
    @Unique
    public boolean insanelib$tryingToStack;
    @Shadow
    private BlockState f_31946_;
    @Shadow
    public int f_31942_;
    @Shadow
    public boolean f_31943_;
    @Shadow
    private boolean f_31947_;
    @Shadow
    @Nullable
    public CompoundTag f_31944_;

    @Shadow
    public abstract void m_149650_(Block var1, BlockPos var2);

    public FallingBlockEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/FallingBlockEntity;discard()V", ordinal=2)})
    private void insanelib$onDiscardOnLand(CallbackInfo ci) {
        ILEventFactory.onFallingBlockLand((FallingBlockEntity)this);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void insanelib$replaceTick(CallbackInfo ci) {
        if (!Feature.isEnabled(BetterFallingBlocks.class)) {
            return;
        }
        ci.cancel();
        if (this.insanelib$shouldDiscardEntity()) {
            return;
        }
        this.insanelib$applyPhysics();
        this.insanelib$handleServerSideLogic();
    }

    @Unique
    private boolean insanelib$shouldDiscardEntity() {
        if (BetterFallingBlocks.fixDupeExploit.booleanValue() && this.m_213877_()) {
            return true;
        }
        if (this.f_31946_.m_60795_()) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    @Unique
    private void insanelib$applyPhysics() {
        ++this.f_31942_;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    @Unique
    private void insanelib$handleServerSideLogic() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockPos blockPos = this.m_20183_();
        boolean isConcretePowder = this.f_31946_.m_60734_() instanceof ConcretePowderBlock;
        boolean canBeHydrated = this.insanelib$checkConcreteHydration(blockPos, isConcretePowder);
        if (!this.m_20096_() && !canBeHydrated) {
            this.insanelib$handleFalling(blockPos);
        } else {
            this.insanelib$handleLanded(blockPos, isConcretePowder, canBeHydrated);
        }
    }

    @Unique
    private boolean insanelib$checkConcreteHydration(BlockPos blockPos, boolean isConcretePowder) {
        BlockHitResult hitResult;
        if (!isConcretePowder) {
            return false;
        }
        boolean canBeHydrated = this.f_31946_.canBeHydrated((BlockGetter)this.m_9236_(), blockPos, this.m_9236_().m_6425_(blockPos), blockPos);
        double velocitySquared = this.m_20184_().m_82556_();
        if (velocitySquared > 1.0 && (hitResult = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
            BlockPos hitPos = hitResult.m_82425_();
            if (this.f_31946_.canBeHydrated((BlockGetter)this.m_9236_(), blockPos, this.m_9236_().m_6425_(hitPos), hitPos)) {
                return true;
            }
        }
        return canBeHydrated;
    }

    @Unique
    private void insanelib$handleFalling(BlockPos blockPos) {
        boolean isOutsideWorld;
        Block block = this.f_31946_.m_60734_();
        boolean bl = isOutsideWorld = blockPos.m_123342_() <= this.m_9236_().m_141937_() || blockPos.m_123342_() > this.m_9236_().m_151558_();
        if (this.f_31942_ > 100 && isOutsideWorld || this.f_31942_ > 600) {
            if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)block);
            }
            this.m_146870_();
        }
    }

    @Unique
    private void insanelib$handleLanded(BlockPos blockPos, boolean isConcretePowder, boolean canBeHydrated) {
        boolean isFreeBelow;
        Block block = this.f_31946_.m_60734_();
        BlockState stateAt = this.m_9236_().m_8055_(blockPos);
        BlockState blockStateBelow = this.m_9236_().m_8055_(blockPos.m_7495_());
        this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        if (stateAt.m_60713_(Blocks.f_50110_)) {
            return;
        }
        if (this.f_31947_) {
            this.m_146870_();
            this.m_149650_(block, blockPos);
            return;
        }
        boolean canReplaceAtPos = stateAt.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
        boolean breakInstaBreak = BetterFallingBlocks.breakInstabreakBlocks;
        boolean isInstaBreak = stateAt.m_60800_((BlockGetter)this.m_9236_(), blockPos) == 0.0f;
        boolean isInstaBreakBelow = blockStateBelow.m_60800_((BlockGetter)this.m_9236_(), blockPos.m_7495_()) == 0.0f;
        boolean canBreakAtPos = isInstaBreak && breakInstaBreak;
        boolean canBreakBelow = isInstaBreakBelow && breakInstaBreak;
        boolean shouldHydrate = isConcretePowder && canBeHydrated;
        boolean bl = isFreeBelow = (FallingBlock.m_53241_((BlockState)blockStateBelow) || canBreakBelow) && !shouldHydrate;
        if (isFreeBelow) {
            if (this.m_20184_().m_82553_() <= (double)1.0E-5f) {
                this.m_6478_(MoverType.SELF, new Vec3(Vec3.m_82512_((Vec3i)this.m_20183_()).f_82479_ - this.m_20182_().f_82479_, 0.0, Vec3.m_82512_((Vec3i)this.m_20183_()).f_82481_ - this.m_20182_().f_82481_));
            }
        } else if (canReplaceAtPos || canBreakAtPos) {
            this.insanelib$place(stateAt, block, blockPos, canBreakAtPos);
        } else if (!breakInstaBreak && isInstaBreak) {
            this.insanelib$handleFailedPlacement(block, blockPos);
        } else {
            this.insanelib$tryStackAboveOrMove(blockPos);
        }
    }

    @Unique
    public void insanelib$tryStackAboveOrMove(BlockPos pos) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        boolean maxStackReached = false;
        while (!this.insanelib$canPlace((BlockPos)blockPos)) {
            blockPos.m_122190_((Vec3i)blockPos.m_7494_());
            if (blockPos.m_123342_() - pos.m_123342_() <= 3) continue;
            maxStackReached = true;
            break;
        }
        if (maxStackReached || this.insanelib$tryingToStack) {
            Direction dir;
            this.insanelib$directionFalling = dir = this.insanelib$selectRandomHorizontalDirection();
            this.insanelib$movedFrom = dir.m_122424_();
            this.m_146884_(this.m_20182_().m_231075_(dir, 1.0));
            this.insanelib$tryingToStack = false;
        } else {
            this.m_6034_(this.m_20185_(), (double)(blockPos.m_123342_() - this.m_146904_()) + this.m_20186_(), this.m_20189_());
            this.insanelib$tryingToStack = true;
        }
    }

    @Unique
    public boolean insanelib$canPlace(BlockPos blockPos) {
        BlockState stateAt = this.m_9236_().m_8055_(blockPos);
        if (!this.insanelib$canPlaceBlock(blockPos, stateAt)) {
            return false;
        }
        BlockState stateBelow = this.m_9236_().m_8055_(blockPos.m_7495_());
        if (FallingBlock.m_53241_((BlockState)stateBelow) && this.f_31946_.m_60710_((LevelReader)this.m_9236_(), blockPos.m_7495_())) {
            this.insanelib$centerHorizontally();
        }
        return true;
    }

    @Unique
    private void insanelib$centerHorizontally() {
        BlockPos posOn = this.m_20097_();
        double deltaX = (double)(this.m_20183_().m_123341_() - posOn.m_123341_()) * 0.5;
        double deltaZ = (double)(this.m_20183_().m_123343_() - posOn.m_123343_()) * 0.5;
        this.m_6478_(MoverType.SELF, new Vec3(deltaX, 0.0, deltaZ));
    }

    @Unique
    private boolean insanelib$canPlaceBlock(BlockPos blockPos, BlockState stateAt) {
        boolean canBeReplaced = stateAt.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
        boolean canBreak = stateAt.m_60800_((BlockGetter)this.m_9236_(), blockPos) == 0.0f && BetterFallingBlocks.breakInstabreakBlocks != false;
        boolean canSurvive = this.f_31946_.m_60710_((LevelReader)this.m_9236_(), blockPos);
        return (canBeReplaced || canBreak) && canSurvive;
    }

    @Unique
    public void insanelib$place(BlockState stateOn, Block block, BlockPos pos, boolean breakBlock) {
        if (breakBlock) {
            this.insanelib$breakBlockAndDropLoot(pos);
        }
        this.insanelib$applyWaterlogging(pos);
        if (this.insanelib$placeBlockState(pos)) {
            this.insanelib$handleSuccessfulPlacement(stateOn, block, pos);
        } else {
            this.insanelib$handleFailedPlacement(block, pos);
        }
    }

    @Unique
    private void insanelib$breakBlockAndDropLoot(BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        BlockState stateToBreak = serverLevel.m_8055_(pos);
        BlockEntity blockEntity = stateToBreak.m_155947_() ? serverLevel.m_7702_(pos) : null;
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, (Object)this);
        stateToBreak.m_222967_(serverLevel, pos, ItemStack.f_41583_, false);
        stateToBreak.m_287290_(lootParamsBuilder).forEach(stack -> serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, pos.m_252807_().f_82479_, pos.m_252807_().f_82480_ + (double)0.6f, pos.m_252807_().f_82481_, stack)));
        serverLevel.m_46961_(pos, false);
    }

    @Unique
    private void insanelib$applyWaterlogging(BlockPos pos) {
        if (this.f_31946_.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            this.f_31946_ = (BlockState)this.f_31946_.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE);
        }
    }

    @Unique
    private boolean insanelib$placeBlockState(BlockPos pos) {
        return this.m_9236_().m_46597_(pos, this.f_31946_);
    }

    @Unique
    private void insanelib$handleSuccessfulPlacement(BlockState stateOn, Block block, BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        Block.m_49931_((BlockState)this.f_31946_, (LevelAccessor)this.m_9236_(), (BlockPos)pos);
        serverLevel.m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(pos, this.m_9236_().m_8055_(pos)));
        this.m_146870_();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)block;
            fallable.m_48792_(this.m_9236_(), pos, this.f_31946_, stateOn, (FallingBlockEntity)this);
        }
        this.insanelib$restoreBlockEntityData(pos);
    }

    @Unique
    private void insanelib$restoreBlockEntityData(BlockPos pos) {
        if (this.f_31944_ == null || !this.f_31946_.m_155947_()) {
            return;
        }
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        CompoundTag compoundTag = blockEntity.m_187482_();
        for (String key : this.f_31944_.m_128431_()) {
            compoundTag.m_128365_(key, this.f_31944_.m_128423_(key).m_6426_());
        }
        try {
            blockEntity.m_142466_(compoundTag);
        }
        catch (Exception exception) {
            LogHelper.error("Failed to load block entity from falling block", exception);
        }
        blockEntity.m_6596_();
    }

    @Unique
    private void insanelib$handleFailedPlacement(Block block, BlockPos pos) {
        if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_146870_();
            this.m_149650_(block, pos);
            this.m_19998_((ItemLike)block);
        }
    }

    @Unique
    private Direction insanelib$selectRandomHorizontalDirection() {
        if (this.insanelib$directionFalling != null) {
            return this.f_19796_.m_188499_() ? this.insanelib$directionFalling.m_122427_() : this.insanelib$directionFalling.m_122428_();
        }
        Direction[] horizontalDirections = (Direction[])Arrays.stream(Direction.values()).filter(dir -> dir.m_122434_().m_122479_() && dir != this.insanelib$movedFrom).toArray(Direction[]::new);
        return horizontalDirections[this.f_19796_.m_188503_(horizontalDirections.length)];
    }

    @Override
    public Entity insanelib$getSource() {
        return this.insanelib$source;
    }

    @Override
    public void insanelib$setSource(Entity entity) {
        this.insanelib$source = entity;
    }
}

