/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib;

import com.mojang.brigadier.CommandDispatcher;
import insane96mcp.insanelib.base.FeatureEnabledCondition;
import insane96mcp.insanelib.base.FeatureEnabledLootCondition;
import insane96mcp.insanelib.command.ILCommand;
import insane96mcp.insanelib.data.JsonFeatureDataReloadListener;
import insane96mcp.insanelib.network.NetworkHandler;
import insane96mcp.insanelib.setup.Config;
import insane96mcp.insanelib.setup.ILGlobalLootModifiers;
import insane96mcp.insanelib.util.IntegratedPack;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="insanelib")
public class InsaneLib {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "insanelib";
    public static DecimalFormat ONE_DECIMAL_FORMATTER;

    public InsaneLib(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC, "insanelib.toml");
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(InsaneLib::clientSetup);
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::addPackFinders);
        modEventBus.addListener(this::registerStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ILGlobalLootModifiers.REGISTRY.register(modEventBus);
    }

    public void preInit(FMLCommonSetupEvent event) {
        NetworkHandler.init();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAddReloadListener(AddReloadListenerEvent event) {
        JsonFeatureDataReloadListener.reloadContext = event.getConditionContext();
        event.addListener((PreparableReloadListener)JsonFeatureDataReloadListener.INSTANCE);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext context = event.getBuildContext();
        ILCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, context);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ONE_DECIMAL_FORMATTER = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.#"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        IntegratedPack.onAddPackFinders(event);
    }

    public static <T> void handleMissingMappings(MissingMappingsEvent event, String modId, ResourceKey<? extends Registry<T>> registry, Function<String, T> handler) {
        for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(registry)) {
            T value;
            ResourceLocation id = mapping.getKey();
            if (!modId.equals(id.m_135827_()) || (value = handler.apply(id.m_135815_())) == null) continue;
            mapping.remap(value);
        }
    }

    public void registerStuff(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)FeatureEnabledCondition.Serializer.INSTANCE);
        }
        if (event.getRegistryKey().equals((Object)Registries.f_256976_)) {
            event.register(Registries.f_256976_, InsaneLib.location("feature_enabled"), () -> FeatureEnabledLootCondition.TYPE);
        }
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

