/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Nullable;

public class ModEnchantmentScreen
extends EnchantmentScreen {
    private static final ResourceLocation ENCHANTING_TABLE_LOCATION = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private static final ResourceLocation ENCHANTING_TABLE_REROLL_LOCATION = new ResourceLocation("easymagic", "textures/gui/container/enchanting_table_reroll.png");
    private final List<List<EnchantmentInstance>> slotData = IntStream.range(0, 3).mapToObj(i -> Lists.newArrayList()).collect(Collectors.toList());

    public ModEnchantmentScreen(EnchantmentMenu container, Inventory playerInventory, Component textComponent) {
        super(container, playerInventory, textComponent);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float tickDelta, int mouseX, int mouseY) {
        if (!((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments || ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook) {
            super.m_7286_(guiGraphics, tickDelta, mouseX, mouseY);
        } else {
            this.renderVanillaBg(guiGraphics, tickDelta, mouseX, mouseY);
            this.renderRerollButton(guiGraphics, tickDelta, mouseX, mouseY);
        }
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, this.f_97735_ + 4, this.f_97736_ + 46, 14, 46, 18, 18);
            guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, this.f_97735_ + 22, this.f_97736_ + 46, 34, 46, 18, 18);
            guiGraphics.m_280218_(ENCHANTING_TABLE_REROLL_LOCATION, this.f_97735_ + 40, this.f_97736_ + 46, 0, 81, 18, 18);
        }
    }

    private void renderVanillaBg(GuiGraphics guiGraphics, float tickDelta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, k, l, 0, 0, this.f_97726_, this.f_97727_);
        EnchantmentNames.m_98734_().m_98735_((long)((EnchantmentMenu)this.f_97732_).m_39493_());
        int q = ((EnchantmentMenu)this.f_97732_).m_39492_();
        for (int r = 0; r < 3; ++r) {
            int s = k + 60;
            int t = s + 20;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int u = ((EnchantmentMenu)this.f_97732_).f_39446_[r];
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (u == 0) {
                guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, s, l + 14 + 19 * r, 0, 185, 108, 19);
                continue;
            }
            String string = String.valueOf(u);
            int v = 86 - this.f_96547_.m_92895_(string);
            FormattedText formattedText = EnchantmentNames.m_98734_().m_98737_(this.f_96547_, v);
            int w = 6839882;
            if (!(q >= r + 1 && this.f_96541_.f_91074_.f_36078_ >= u || this.f_96541_.f_91074_.m_150110_().f_35937_)) {
                guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, s, l + 14 + 19 * r, 0, 185, 108, 19);
                guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, s + 1, l + 15 + 19 * r, 16 * r, 239, 16, 16);
                guiGraphics.m_280554_(this.f_96547_, formattedText, t, l + 16 + 19 * r, v, (w & 0xFEFEFE) >> 1);
                w = 4226832;
            } else {
                int x = mouseX - (k + 60);
                int y = mouseY - (l + 14 + 19 * r);
                if (x >= 0 && y >= 0 && x < 108 && y < 19) {
                    guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, s, l + 14 + 19 * r, 0, 204, 108, 19);
                    w = 0xFFFF80;
                } else {
                    guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, s, l + 14 + 19 * r, 0, 166, 108, 19);
                }
                guiGraphics.m_280218_(ENCHANTING_TABLE_LOCATION, s + 1, l + 15 + 19 * r, 16 * r, 223, 16, 16);
                guiGraphics.m_280554_(this.f_96547_, formattedText, t, l + 16 + 19 * r, v, w);
                w = 8453920;
            }
            guiGraphics.m_280488_(this.f_96547_, string, t + 86 - this.f_96547_.m_92895_(string), l + 16 + 19 * r + 7, w);
        }
    }

    private void renderRerollButton(GuiGraphics guiGraphics, float tickDelta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int experienceCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost;
        int lapisCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
        boolean invalid = !this.f_96541_.f_91074_.m_150110_().f_35937_ && (PlayerExperienceHelper.getTotalExperience((Player)this.f_96541_.f_91074_) < experienceCost || this.getMenu().getRerollCatalystCount() < lapisCost);
        int buttonX = this.f_97735_ + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
        int buttonY = this.f_97736_ + 16;
        boolean hovered = this.isMouseOverReroll(mouseX, mouseY);
        boolean canUseReroll = this.getMenu().canUseReroll();
        guiGraphics.m_280218_(ENCHANTING_TABLE_REROLL_LOCATION, buttonX, buttonY, 0, !canUseReroll || invalid ? 0 : (hovered ? 54 : 27), 38, 27);
        if (canUseReroll) {
            if (experienceCost == 0 && lapisCost == 0) {
                guiGraphics.m_280218_(ENCHANTING_TABLE_REROLL_LOCATION, buttonX + 12, buttonY + 6, 64, invalid ? 0 : (hovered ? 30 : 15), 15, 15);
            } else {
                guiGraphics.m_280218_(ENCHANTING_TABLE_REROLL_LOCATION, buttonX + 3, buttonY + 6, 64, invalid ? 0 : (hovered ? 30 : 15), 15, 15);
                if (experienceCost > 0 && lapisCost > 0) {
                    this.renderCostOrb(guiGraphics, buttonX + (experienceCost > 9 ? 17 : 20), buttonY + 13, 38, invalid ? 39 : 0, experienceCost, invalid ? ChatFormatting.RED : ChatFormatting.GREEN);
                    this.renderCostOrb(guiGraphics, buttonX + (lapisCost > 9 ? 17 : 20), buttonY + 1, 51, invalid ? 39 : 0, lapisCost, invalid ? ChatFormatting.RED : ChatFormatting.BLUE);
                } else if (experienceCost > 0) {
                    this.renderCostOrb(guiGraphics, buttonX + (experienceCost > 9 ? 17 : 20), buttonY + 7, 38, invalid ? 39 : 0, experienceCost, invalid ? ChatFormatting.RED : ChatFormatting.GREEN);
                } else if (lapisCost > 0) {
                    this.renderCostOrb(guiGraphics, buttonX + (lapisCost > 9 ? 17 : 20), buttonY + 7, 51, invalid ? 39 : 0, lapisCost, invalid ? ChatFormatting.RED : ChatFormatting.BLUE);
                }
            }
        }
    }

    private void renderCostOrb(GuiGraphics guiGraphics, int posX, int posY, int textureX, int textureY, int cost, ChatFormatting color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(ENCHANTING_TABLE_REROLL_LOCATION, posX, posY, textureX, textureY + Math.min(2, cost / 5) * 13, 13, 13);
        this.renderReadableText(guiGraphics, posX + 8, posY + 3, String.valueOf(cost), color.m_126665_());
    }

    private void renderReadableText(GuiGraphics guiGraphics, int posX, int posY, String text, int color) {
        guiGraphics.m_280056_(this.f_96547_, text, posX - 1, posY, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX + 1, posY, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX, posY - 1, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX, posY + 1, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX, posY, color, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.isMouseOverReroll((int)mouseX, (int)mouseY) && ((EnchantmentMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 4)) {
            this.f_96541_.f_91072_.m_105208_(((EnchantmentMenu)this.f_97732_).f_38840_, 4);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11887_, (float)1.0f));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int slot = this.getEnchantingSlot(mouseX, mouseY);
        if (slot != -1) {
            if (!this.slotData.get(slot).isEmpty()) {
                ArrayList tooltip = Lists.newArrayList();
                boolean hasValidEnchantment = this.gatherSlotEnchantmentsTooltip(this.slotData.get(slot), tooltip);
                this.gatherSlotCostsTooltip(slot, tooltip, hasValidEnchantment);
                guiGraphics.m_280666_(this.f_96547_, (List)tooltip, mouseX, mouseY);
            }
        } else if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.isMouseOverReroll(mouseX, mouseY) && this.getMenu().canUseReroll()) {
            ArrayList tooltip = Lists.newArrayList();
            this.gatherRerollTooltip(tooltip);
            guiGraphics.m_280666_(this.f_96547_, (List)tooltip, mouseX, mouseY);
        }
    }

    private boolean isMouseOverReroll(int mouseX, int mouseY) {
        int startX = this.f_97735_ + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
        int startY = this.f_97736_ + 16;
        return startX < mouseX && mouseX <= startX + 38 && startY < mouseY && mouseY <= startY + 27;
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (this.getSelectedSlot(mouseX, mouseY) != null) {
            return super.m_6774_(x, y, width, height, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private Slot getSelectedSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((EnchantmentMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((EnchantmentMenu)this.f_97732_).f_38839_.get(i);
            if (!this.isSlotSelected(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    private boolean isSlotSelected(Slot slotIn, double mouseX, double mouseY) {
        return super.m_6774_(slotIn.f_40220_, slotIn.f_40221_, 16, 16, mouseX, mouseY);
    }

    private int getEnchantingSlot(int mouseX, int mouseY) {
        for (int j = 0; j < 3; ++j) {
            int levels = ((EnchantmentMenu)this.f_97732_).f_39446_[j];
            if (!super.m_6774_(60, 14 + 19 * j, 108, 17, (double)mouseX, (double)mouseY) || levels <= 0) continue;
            return j;
        }
        return -1;
    }

    public void setSlotData(int slot, List<EnchantmentInstance> data) {
        this.slotData.set(slot, data);
    }

    private boolean gatherSlotEnchantmentsTooltip(List<EnchantmentInstance> slotData, List<Component> slotTooltip) {
        boolean hasValidEnchantment = slotData.isEmpty();
        for (EnchantmentInstance data : slotData) {
            if (data.f_44947_ == null) continue;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint == ServerConfig.EnchantmentHint.ALL) {
                slotTooltip.add((Component)((MutableComponent)data.f_44947_.m_44700_(data.f_44948_)).m_130940_(ChatFormatting.GRAY));
            } else {
                slotTooltip.add((Component)Component.m_237110_((String)"container.enchant.clue", (Object[])new Object[]{data.f_44947_.m_44700_(data.f_44948_)}).m_130940_(ChatFormatting.GRAY));
            }
            hasValidEnchantment = true;
        }
        return hasValidEnchantment;
    }

    private void gatherSlotCostsTooltip(int slot, List<Component> slotTooltip, boolean hasValidEnchantment) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isForge() && !hasValidEnchantment) {
            additionalTooltip.add(Component.m_237115_((String)"forge.container.enchant.limitedEnchantability").m_130940_(ChatFormatting.RED));
        } else if (!this.f_96541_.f_91074_.m_150110_().f_35937_) {
            int enchantLevels = ((EnchantmentMenu)this.f_97732_).f_39446_[slot];
            if (this.f_96541_.f_91074_.f_36078_ < enchantLevels) {
                additionalTooltip.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantLevels}).m_130940_(ChatFormatting.RED));
            } else {
                ModEnchantmentScreen.getEnchantingComponent(slot + 1, ((EnchantmentMenu)this.f_97732_).m_39492_(), "container.enchant.lapis.one", "container.enchant.lapis.many").ifPresent(additionalTooltip::add);
                ModEnchantmentScreen.getEnchantingComponent(slot + 1, this.f_96541_.f_91074_.f_36078_, "container.enchant.level.one", "container.enchant.level.many").ifPresent(additionalTooltip::add);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!slotTooltip.isEmpty()) {
                slotTooltip.add((Component)Component.m_237119_());
            }
            slotTooltip.addAll(additionalTooltip);
        }
    }

    private void gatherRerollTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"container.enchant.reroll").m_130940_(ChatFormatting.GRAY));
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!this.f_96541_.f_91074_.m_150110_().f_35937_) {
            int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
                MutableComponent component = Component.m_237113_((String)(rerollCatalystCost + " ")).m_7220_(Items.f_151049_.m_41466_());
                ModEnchantmentScreen.getEnchantingComponent(rerollCatalystCost, this.getMenu().getRerollCatalystCount(), component).ifPresent(additionalTooltip::add);
            } else {
                ModEnchantmentScreen.getEnchantingComponent(rerollCatalystCost, this.getMenu().getRerollCatalystCount(), "container.enchant.lapis.one", "container.enchant.lapis.many").ifPresent(additionalTooltip::add);
            }
            ModEnchantmentScreen.getEnchantingComponent(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost, PlayerExperienceHelper.getTotalExperience((Player)this.f_96541_.f_91074_), "container.enchant.experience.one", "container.enchant.experience.many").ifPresent(additionalTooltip::add);
        }
        if (!additionalTooltip.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.addAll(additionalTooltip);
        }
    }

    private static Optional<Component> getEnchantingComponent(int requiredAmount, int currentAmount, String singleKey, String manyKey) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        MutableComponent component = requiredAmount == 1 ? Component.m_237115_((String)singleKey) : Component.m_237110_((String)manyKey, (Object[])new Object[]{requiredAmount});
        return ModEnchantmentScreen.getEnchantingComponent(requiredAmount, currentAmount, component);
    }

    private static Optional<Component> getEnchantingComponent(int requiredAmount, int currentAmount, MutableComponent component) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        return Optional.of(component.m_130940_(currentAmount >= requiredAmount ? ChatFormatting.GRAY : ChatFormatting.RED));
    }

    public ModEnchantmentMenu getMenu() {
        return (ModEnchantmentMenu)super.m_6262_();
    }
}

