/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ExportWorldPresetMessage(UUID uuid, String name) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "export_world_preset");

    public static ExportWorldPresetMessage create(FriendlyByteBuf buffer) {
        return new ExportWorldPresetMessage(buffer.m_130259_(), buffer.m_130277_());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.name);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.warn("Export preset name is empty for {}", easyNPC);
            return;
        }
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("Export preset skin data is empty for {}", easyNPC);
            return;
        }
        SkinModel skinModel = skinData.getSkinModel();
        if (skinModel == null) {
            log.warn("Export preset skin model is empty for {}", easyNPC);
            return;
        }
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        CompoundTag compoundTag = presetData.exportPresetData();
        if (compoundTag == null || compoundTag.m_128456_()) {
            log.warn("Export preset data is empty for {}", easyNPC);
            return;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile(skinModel, this.name);
        if (presetFile == null) {
            log.error("Failed to get preset file for {} with name {}", (Object)skinModel, (Object)this.name);
            return;
        }
        log.info("Exporting EasyNPC {} with {} and skin {} to {}", (Object)this.name, easyNPC, (Object)skinModel, (Object)presetFile);
        try {
            NbtIo.m_128944_((CompoundTag)compoundTag, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with {} and skin {} to {}:", (Object)this.name, easyNPC, (Object)skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

