/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.RenderHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record ChangeRendererMessage(UUID uuid, RenderType renderType, Optional<EntityType<?>> renderEntityType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_renderer");

    public static ChangeRendererMessage create(FriendlyByteBuf buffer) {
        return new ChangeRendererMessage(buffer.m_130259_(), (RenderType)buffer.m_130066_(RenderType.class), EntityType.m_20632_((String)buffer.m_130277_()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.renderType);
        buffer.m_130070_(this.renderEntityType.map(entityType -> EntityType.m_20613_((EntityType)entityType).toString()).orElse(""));
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.renderType != null) {
            RenderHandler.setRenderType(easyNPC, this.renderType);
        }
        this.renderEntityType.ifPresent(entityType -> RenderHandler.setRenderEntity(easyNPC, (EntityType<? extends Entity>)entityType));
    }
}

