/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.gametest;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.gametest.GameTestHelpers;
import de.markusbordihn.easynpc.menu.MenuHandlerInterface;
import de.markusbordihn.easynpc.menu.MenuManager;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@PrefixGameTestTemplate(value=false)
@GameTestHolder(value="easy_npc")
public class MenuManagerTest {
    @GameTest(template="gametest.1x1x1")
    public void testMissingConfigurationType(GameTestHelper helper) {
        MenuHandlerInterface menuHandlerInterface = MenuManager.getMenuHandler();
        for (ConfigurationType configurationType : ConfigurationType.values()) {
            if (configurationType == ConfigurationType.NONE || configurationType.isAlias()) continue;
            GameTestHelpers.assertNotNull(helper, "Menu type for configuration type " + configurationType + " is missing!", menuHandlerInterface.getMenuTypeByConfigurationType(configurationType));
        }
        helper.m_177412_();
    }

    @GameTest(template="gametest.1x1x1")
    public void testMissingEditorType(GameTestHelper helper) {
        MenuHandlerInterface menuHandlerInterface = MenuManager.getMenuHandler();
        for (EditorType editorTypeType : EditorType.values()) {
            if (editorTypeType == EditorType.NONE) continue;
            GameTestHelpers.assertNotNull(helper, "Menu type for editor type " + editorTypeType + " is missing!", menuHandlerInterface.getMenuTypeByEditorType(editorTypeType));
        }
        helper.m_177412_();
    }
}

