/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String LOG_PREFIX = "[Living Entity Manager]";
    private static final ConcurrentHashMap<String, ServerPlayer> playerNameMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, EasyNPC<?>> npcEntityMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, ServerPlayer> playerMap = new ConcurrentHashMap();

    private LivingEntityManager() {
    }

    public static void addEasyNPC(EasyNPC<?> easyNPC) {
        UUID uuid = easyNPC.m_20148_();
        log.debug("{} [Add] EASY NPC entity {}: {}", (Object)LOG_PREFIX, easyNPC, (Object)uuid);
        npcEntityMap.put(uuid, easyNPC);
        if (easyNPC.m_183595_()) {
            return;
        }
        for (EasyNPC<?> easyNPCChild : npcEntityMap.values()) {
            if (easyNPCChild == easyNPC) continue;
            easyNPCChild.handleEasyNPCJoin(easyNPC);
        }
    }

    public static void removeEasyNPC(EasyNPC<?> easyNPC) {
        log.debug("{} [Remove] EASY NPC entity {}: {}", (Object)LOG_PREFIX, easyNPC, (Object)easyNPC.m_20148_());
        npcEntityMap.remove(easyNPC.m_20148_());
        if (easyNPC.m_183595_()) {
            return;
        }
        for (EasyNPC<?> easyNPCChild : npcEntityMap.values()) {
            if (easyNPCChild == easyNPC) continue;
            easyNPCChild.handleEasyNPCLeave(easyNPC);
        }
    }

    public static void addLivingEntity(LivingEntity livingEntity) {
        if (log.isTraceEnabled()) {
            log.trace("{} [Add] Living entity {}: {}", (Object)LOG_PREFIX, (Object)livingEntity, (Object)livingEntity.m_20148_());
        }
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handleLivingEntityJoin(livingEntity);
        }
    }

    public static void removeLivingEntity(LivingEntity livingEntity) {
        if (log.isTraceEnabled()) {
            log.trace("{} [Remove] Living entity {}: {}", (Object)LOG_PREFIX, (Object)livingEntity, (Object)livingEntity.m_20148_());
        }
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handleLivingEntityLeave(livingEntity);
        }
    }

    public static void addServerPlayer(ServerPlayer serverPlayer) {
        log.debug("{} [Add] Server player {}: {}", (Object)LOG_PREFIX, (Object)serverPlayer, (Object)serverPlayer.m_20148_());
        playerMap.put(serverPlayer.m_20148_(), serverPlayer);
        playerNameMap.put(serverPlayer.m_7755_().getString(), serverPlayer);
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handlePlayerJoin(serverPlayer);
        }
    }

    public static void removeServerPlayer(ServerPlayer serverPlayer) {
        log.debug("{} [Remove] Server player {}: {}", (Object)LOG_PREFIX, (Object)serverPlayer, (Object)serverPlayer.m_20148_());
        playerMap.remove(serverPlayer.m_20148_());
        playerNameMap.remove(serverPlayer.m_7755_().getString());
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handlePlayerLeave(serverPlayer);
        }
    }

    public static LivingEntity getLivingEntityByUUID(UUID uuid, ServerLevel serverLevel) {
        if (uuid == null || serverLevel == null) {
            return null;
        }
        Entity entity = serverLevel.m_8791_(uuid);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        ServerPlayer serverPlayer = LivingEntityManager.getPlayerByUUID(uuid, serverLevel);
        if (serverPlayer != null) {
            return serverPlayer;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverLevel);
        return easyNPC != null ? easyNPC.getLivingEntity() : null;
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, ServerPlayer serverPlayer) {
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer.m_284548_());
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, ServerLevel serverLevel) {
        if (uuid == null || serverLevel == null) {
            return null;
        }
        Entity entity = serverLevel.m_8791_(uuid);
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return easyNPC;
        }
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid);
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return npcEntityMap.getOrDefault(uuid, null);
    }

    public static ServerPlayer getPlayerByUUID(UUID uuid, ServerLevel serverLevel) {
        if (uuid == null || serverLevel == null) {
            return null;
        }
        Player player = serverLevel.m_46003_(uuid);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer;
        }
        return playerMap.getOrDefault(uuid, null);
    }

    public static ServerPlayer getPlayerByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return playerNameMap.getOrDefault(name, null);
    }

    public static Stream<String> getUUIDStrings() {
        return npcEntityMap.keySet().stream().map(UUID::toString);
    }

    public static Stream<String> getUUIDStringsByOwner(ServerPlayer serverPlayer) {
        Map<UUID, Entity> npcEntityMapByOwner = LivingEntityManager.getEntityMapByOwner(serverPlayer);
        return npcEntityMapByOwner != null ? npcEntityMapByOwner.keySet().stream().map(UUID::toString) : Stream.empty();
    }

    public static Map<UUID, Entity> getEntityMapByOwner(ServerPlayer serverPlayer) {
        return serverPlayer != null ? LivingEntityManager.getEntityMapByOwner(serverPlayer.m_20148_()) : null;
    }

    public static Map<UUID, Entity> getEntityMapByOwner(UUID ownerUUID) {
        HashMap<UUID, Entity> result = new HashMap<UUID, Entity>();
        for (Map.Entry<UUID, EasyNPC<?>> entry : npcEntityMap.entrySet()) {
            OwnerData ownerData;
            EasyNPC<?> easyNPC = entry.getValue();
            if (!(easyNPC instanceof OwnerData) || !(ownerData = (OwnerData)easyNPC).isOwner(ownerUUID)) continue;
            result.put(entry.getKey(), easyNPC.getEntity());
        }
        return result;
    }

    public static ConcurrentHashMap<UUID, EasyNPC<?>> getNpcEntityMap() {
        return npcEntityMap;
    }

    public static boolean hasAccess(UUID uuid, ServerPlayer serverPlayer) {
        if (uuid == null || serverPlayer == null) {
            return false;
        }
        return LivingEntityManager.hasAccess(serverPlayer.m_284548_().m_8791_(uuid), serverPlayer);
    }

    public static boolean hasAccess(Entity entity, ServerPlayer serverPlayer) {
        EasyNPC easyNPC;
        if (serverPlayer.m_7500_()) {
            return true;
        }
        if (entity instanceof EasyNPC && (easyNPC = (EasyNPC)entity) instanceof OwnerData) {
            OwnerData ownerData = (OwnerData)easyNPC;
            UUID uuid = ownerData.m_21805_();
            return uuid != null && uuid.equals(serverPlayer.m_20148_());
        }
        return false;
    }

    public static void discardEasyNPCEntityByUUID(UUID uuid, ServerLevel serverLevel) {
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverLevel);
        if (easyNPC != null && easyNPC.getMob() != null) {
            easyNPC.getMob().m_146870_();
            npcEntityMap.remove(uuid);
        } else {
            log.warn("{} [Discard] Unable to discard EASY NPC entity {}: {}", (Object)LOG_PREFIX, easyNPC, (Object)uuid);
        }
    }
}

