/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.animation;

import com.google.gson.Gson;
import de.markusbordihn.easynpc.data.animation.AnimationData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnimationDataReader {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String LOG_PREFIX = "[Animation Data Reader]";
    private static final String SUPPORTED_FORMAT_VERSION = "1.8.0";

    public static AnimationData parseAnimationFile(String filePath) throws IOException {
        return AnimationDataReader.parseAnimationFile(Paths.get(filePath, new String[0]));
    }

    public static AnimationData parseAnimationFile(Path filePath) throws IOException {
        Gson gson = new Gson();
        BufferedReader reader = Files.newBufferedReader(filePath);
        AnimationData animationData = (AnimationData)gson.fromJson((Reader)reader, AnimationData.class);
        if (!SUPPORTED_FORMAT_VERSION.equals(animationData.getFormatVersion())) {
            log.warn("{} Unsupported format version {} in file {}, will try to load it anyway.", (Object)LOG_PREFIX, (Object)animationData.getFormatVersion(), (Object)filePath);
        }
        for (Map.Entry<String, AnimationData.Animation> entry : animationData.getAnimations().entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return animationData;
    }
}

