/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class BaseHierarchicalArmLegsModel<E extends Mob>
extends HierarchicalModel<E>
implements ArmedModel,
EasyNPCModel<E> {
    public final ModelPart head;
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    protected final ModelPart root;
    protected final ModelPart body;
    protected final ModelPart rightArm;
    protected final ModelPart leftArm;
    protected final ModelPart rightLeg;
    protected final ModelPart leftLeg;

    public BaseHierarchicalArmLegsModel(ModelPart modelPart) {
        this.root = ModelHelper.hasModelPart(modelPart, "root") ? this.defineModelPart(ModelPartType.ROOT, modelPart, "root") : this.defineModelPart(ModelPartType.ROOT, modelPart);
        this.head = ModelHelper.hasModelPart(modelPart, "head") ? this.defineModelPart(ModelPartType.HEAD, modelPart, "head") : this.defineModelPart(ModelPartType.HEAD, this.root, "head");
        this.body = ModelHelper.hasModelPart(modelPart, "body") ? this.defineModelPart(ModelPartType.BODY, modelPart, "body") : this.defineModelPart(ModelPartType.BODY, this.root, "body");
        this.rightArm = ModelHelper.hasModelPart(modelPart, "right_arm") ? this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm") : this.defineModelPart(ModelPartType.RIGHT_ARM, this.body, "right_arm");
        this.leftArm = ModelHelper.hasModelPart(modelPart, "left_arm") ? this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm") : this.defineModelPart(ModelPartType.LEFT_ARM, this.body, "left_arm");
        this.rightLeg = ModelHelper.hasModelPart(modelPart, "right_leg") ? this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg") : this.defineModelPart(ModelPartType.RIGHT_LEG, this.body, "right_leg");
        this.leftLeg = ModelHelper.hasModelPart(modelPart, "left_leg") ? this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg") : this.defineModelPart(ModelPartType.LEFT_LEG, this.body, "left_leg");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.rightArm);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.leftArm);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.f_104203_ = headPitch * ((float)Math.PI / 180);
        headPart.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public boolean animateModelRightArm(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        AnimationUtils.m_170341_((ModelPart)rightArmPart, (float)ageInTicks, (float)0.5f);
        return true;
    }

    @Override
    public boolean animateModelLeftArm(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        AnimationUtils.m_170341_((ModelPart)leftArmPart, (float)ageInTicks, (float)-0.5f);
        return true;
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftArm, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightArm, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.f_104203_ = 0.5f;
        this.body.f_104201_ = 3.2f;
        this.head.f_104201_ = 4.2f;
        this.leftArm.f_104203_ += 0.4f;
        this.leftArm.f_104201_ = 5.2f;
        this.leftLeg.f_104201_ = 12.2f;
        this.leftLeg.f_104202_ = 4.0f;
        this.rightArm.f_104203_ += 0.4f;
        this.rightArm.f_104201_ = 5.2f;
        this.rightLeg.f_104201_ = 12.2f;
        this.rightLeg.f_104202_ = 4.0f;
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, ModelPart> getModelPartMap() {
        return this.modelPartMap;
    }

    protected ModelPart getArm(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        ModelPart modelpart = this.getArm(humanoidArm);
        modelpart.m_104299_(poseStack);
    }
}

