/*
 * Decompiled with CFR 0.152.
 */
package com.newjumper.denseores;

import com.newjumper.denseores.content.DenseBlocks;
import com.newjumper.denseores.datagen.assets.DenseOresBlockStateProvider;
import com.newjumper.denseores.datagen.assets.DenseOresItemModelProvider;
import com.newjumper.denseores.datagen.assets.ENLanguageProvider;
import com.newjumper.denseores.datagen.data.DenseOresBiomeTagsProvider;
import com.newjumper.denseores.datagen.data.DenseOresBlockTagsProvider;
import com.newjumper.denseores.datagen.data.DenseOresItemTagsProvider;
import com.newjumper.denseores.datagen.data.DenseOresLootTableProvider;
import com.newjumper.denseores.datagen.data.DenseOresWorldGen;
import com.newjumper.denseores.datagen.data.SmeltingRecipesProvider;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="denseores")
public class DenseOres {
    public static final String MOD_ID = "denseores";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"denseores");
    public static final RegistryObject<CreativeModeTab> DENSE_ORES = CREATIVE_MODE_TABS.register("dense_ores", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.denseores")).m_257737_(() -> new ItemStack((ItemLike)DenseBlocks.DENSE_DIAMOND_ORE.get())).m_257652_());

    public DenseOres() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CREATIVE_MODE_TABS.register(eventBus);
        DenseBlocks.BLOCKS.register(eventBus);
        DenseBlocks.ITEMS.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        eventBus.addListener(this::buildCreativeTab);
        eventBus.addListener(this::generateData);
    }

    public void buildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == DENSE_ORES.get()) {
            DenseBlocks.BLOCKS.getEntries().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    public void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new DenseOresBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DenseOresItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ENLanguageProvider(packOutput));
        DenseOresBlockTagsProvider blockTags = new DenseOresBlockTagsProvider(packOutput, event.getLookupProvider(), fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new DenseOresItemTagsProvider(packOutput, event.getLookupProvider(), (TagsProvider<Block>)blockTags, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DenseOresBiomeTagsProvider(packOutput, event.getLookupProvider(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DenseOresWorldGen(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new DenseOresLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new SmeltingRecipesProvider(packOutput));
    }
}

