/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.List;
import java.util.Objects;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;

public class GenericMapTypeID
implements TypeID {
    public final TypeID value;
    public final TypeParameter key;
    private final GenericMapTypeID normalized;

    public GenericMapTypeID(GlobalTypeRegistry registry, TypeID value, TypeParameter key) {
        this.value = value;
        this.key = key;
        this.normalized = value.getNormalized() == value ? this : registry.getGenericMap(value.getNormalized(), key);
    }

    @Override
    public GenericMapTypeID getNormalized() {
        return this.normalized;
    }

    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visitGenericMap(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitGenericMap(context, this);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public TypeID instance(GenericMapper mapper) {
        return mapper.registry.getGenericMap(this.value.instance(mapper), this.key);
    }

    @Override
    public boolean hasDefaultValue() {
        return true;
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        this.value.extractTypeParameters(typeParameters);
        typeParameters.remove(this.key);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.value.toString());
        result.append("[<");
        result.append(this.key.toString());
        result.append(">]");
        return result.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.value.hashCode();
        hash = 97 * hash + this.key.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericMapTypeID other = (GenericMapTypeID)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.key, other.key);
    }
}

