/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import java.util.Collections;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CapturedDirectExpression;
import org.openzen.zenscript.codemodel.expression.CapturedExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.expression.LambdaClosure;
import org.openzen.zenscript.codemodel.expression.SetFieldExpression;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.ref.FieldMemberRef;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.TypeID;

public class GetFieldExpression
extends Expression {
    public final Expression target;
    public final FieldMemberRef field;

    public GetFieldExpression(CodePosition position, Expression target, FieldMemberRef field) {
        super(position, field.getType(), target.thrownType);
        this.target = target;
        this.field = field;
    }

    @Override
    public List<TypeID> getAssignHints() {
        return Collections.singletonList(this.type);
    }

    @Override
    public CapturedExpression capture(CodePosition position, LambdaClosure closure) {
        return new CapturedDirectExpression(position, closure, this);
    }

    @Override
    public Expression assign(CodePosition position, TypeScope scope, Expression value) {
        return new SetFieldExpression(position, this.target, this.field, value);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitGetField(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitGetField(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression tTarget = this.target.transform(transformer);
        return tTarget == this.target ? this : new GetFieldExpression(this.position, tTarget, this.field);
    }

    @Override
    public IDefinitionMember getMember() {
        return this.field.member;
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return new GetFieldExpression(this.position, this.target.normalize(scope), this.field);
    }
}

