/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.manager.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagAdd;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagClear;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagCreate;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagRemove;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.tag.MutableLoadResult;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.type.UnknownTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagManager;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"crafttweaker", "tags"})
@Document(value="vanilla/api/tag/manager/type/UnknownTagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.manager.type.UnknownTagManager")
public class UnknownTagManager
implements ITagManager<UnknownTag> {
    private final ResourceKey<? extends Registry<?>> resourceKey;
    private final MutableLoadResult<?> backingResult;
    private Map<ResourceLocation, UnknownTag> tagCache;

    public UnknownTagManager(ResourceKey<? extends Registry<?>> resourceKey) {
        this.resourceKey = resourceKey;
        this.backingResult = new MutableLoadResult();
        this.tagCache = new HashMap<ResourceLocation, UnknownTag>();
    }

    @Override
    public ResourceKey<? extends Registry<?>> resourceKey() {
        return this.resourceKey;
    }

    @Override
    @ZenCodeType.Method
    public final void addId(UnknownTag to, ResourceLocation ... values) {
        if (!this.exists(to)) {
            CraftTweakerAPI.apply(new ActionUnknownTagCreate(to));
        }
        CraftTweakerAPI.apply(new ActionUnknownTagAdd(to, List.of(values)));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public final void removeId(UnknownTag from, ResourceLocation ... values) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionUnknownTagRemove(from, List.of(values)));
        this.recalculate();
    }

    @Override
    public void clear(UnknownTag from) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionUnknownTagClear(from));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public UnknownTag tag(String id) {
        return this.tag(new ResourceLocation(id));
    }

    @Override
    @ZenCodeType.Method
    public UnknownTag tag(ResourceLocation id) {
        return this.tagMap().getOrDefault(id, new UnknownTag(id, this));
    }

    @Override
    public void recalculate() {
        this.tagCache.clear();
        for (ResourceLocation id : this.backingResult.tagMap().keySet()) {
            this.tagCache.put(id, new UnknownTag(id, this));
        }
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagMap")
    public Map<ResourceLocation, UnknownTag> tagMap() {
        if (this.tagCache.isEmpty()) {
            this.recalculate();
        }
        return this.tagCache;
    }

    @Override
    public Map<ResourceLocation, Collection<Holder<?>>> internalTags() {
        return (Map)GenericUtil.uncheck(Collections.unmodifiableMap(this.backingResult.tagMap()));
    }

    @Override
    @Nullable
    public Collection<Holder<?>> getInternalRaw(UnknownTag tag) {
        return (Collection)GenericUtil.uncheck(this.backingResult.tagMap().get(tag.id()));
    }

    @Override
    public List<ResourceLocation> tagKeys() {
        return new ArrayList<ResourceLocation>(this.tagMap().keySet());
    }

    @Override
    public <U> void addTag(ResourceLocation id, Collection<Holder<U>> tag) {
        this.backingResult.addTag(id, (Collection)GenericUtil.uncheck(tag));
        this.recalculate();
    }

    @Override
    public void bind(TagManager.LoadResult<?> result) {
        this.backingResult.bind((TagManager.LoadResult)GenericUtil.uncheck(result));
    }
}

