/*
 * Decompiled with CFR 0.152.
 */
package com.example.lootbag;

import com.example.lootbag.BountyBagsConfig;
import com.example.lootbag.CustomLootGenerator;
import com.example.lootbag.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootBagItem
extends Item {
    public LootBagItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ObjectArrayList generatedItems = new ArrayList();
                if (((Boolean)BountyBagsConfig.USE_CUSTOM_LOOT.get()).booleanValue()) {
                    generatedItems = CustomLootGenerator.generateLoot(level, stack.m_41720_());
                }
                if (generatedItems.isEmpty()) {
                    ResourceLocation lootTableLocation = this.getLootTableResource(stack.m_41720_());
                    LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
                    if (lootTable != LootTable.f_79105_) {
                        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)serverPlayer).m_287286_(LootContextParams.f_81460_, (Object)serverPlayer.m_20182_()).m_287239_(serverPlayer.m_36336_()).m_287235_(LootContextParamSets.f_81416_);
                        generatedItems = lootTable.m_287195_(lootParams);
                    }
                }
                generatedItems.forEach(itemStack -> {
                    if (!player.m_150109_().m_36054_(itemStack)) {
                        player.m_36176_(itemStack, false);
                    }
                });
                stack.m_41774_(1);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    private ResourceLocation getLootTableResource(Item item) {
        if (item == ItemRegistry.RARE_LOOT_BAG.get()) {
            return new ResourceLocation("bountybags", "items/rare");
        }
        if (item == ItemRegistry.SUPER_RARE_LOOT_BAG.get()) {
            return new ResourceLocation("bountybags", "items/super_rare");
        }
        if (item == ItemRegistry.EPIC_LOOT_BAG.get()) {
            return new ResourceLocation("bountybags", "items/epic");
        }
        if (item == ItemRegistry.LEGENDARY_LOOT_BAG.get()) {
            return new ResourceLocation("bountybags", "items/legendary");
        }
        return LootTable.f_79105_.getLootTableId();
    }
}

