/*
 * Decompiled with CFR 0.152.
 */
package com.example.lootbag;

import com.example.lootbag.BountyBagsConfig;
import com.example.lootbag.ItemRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="bountybags")
public class EventHandler {
    private static final TagKey<Biome> NETHER_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("forge", "is_nether"));

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        double rare;
        double superRare;
        double epic;
        double legendary;
        boolean canDropBags;
        Level level;
        if (!((Boolean)BountyBagsConfig.ENABLE_DROPS.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_9236_().f_46443_ || !((level = event.getEntity().m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity entity = event.getEntity();
        EntityType entityType = entity.m_6095_();
        ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
        if (entityTypeId == null) {
            return;
        }
        String entityTypeString = entityTypeId.toString();
        List bossMobs = (List)BountyBagsConfig.BOSS_MOB_TYPES.get();
        boolean isBoss = bossMobs.contains(entityTypeString);
        if (((Boolean)BountyBagsConfig.USE_ALL_AGGRESSIVE_MOBS.get()).booleanValue()) {
            canDropBags = entity instanceof Monster || isBoss;
        } else {
            List allowedMobs = (List)BountyBagsConfig.ALLOWED_MOB_TYPES.get();
            boolean bl = canDropBags = allowedMobs.contains(entityTypeString) || isBoss;
        }
        if (!canDropBags) {
            return;
        }
        boolean isInNether = false;
        if (((Boolean)BountyBagsConfig.ENABLE_NETHER_BONUS.get()).booleanValue()) {
            Holder biomeHolder = serverLevel.m_204166_(entity.m_20183_());
            isInNether = biomeHolder.m_203656_(NETHER_BIOMES);
        }
        if (isBoss && ((Boolean)BountyBagsConfig.ENABLE_BOSS_SPECIAL_RATES.get()).booleanValue()) {
            legendary = (Double)BountyBagsConfig.BOSS_LEGENDARY_CHANCE.get();
            epic = (Double)BountyBagsConfig.BOSS_EPIC_CHANCE.get();
            superRare = 0.0;
            rare = 0.0;
        } else {
            legendary = (Double)BountyBagsConfig.LEGENDARY_CHANCE.get();
            epic = (Double)BountyBagsConfig.EPIC_CHANCE.get();
            superRare = (Double)BountyBagsConfig.SUPER_RARE_CHANCE.get();
            rare = (Double)BountyBagsConfig.RARE_CHANCE.get();
            if (isInNether) {
                legendary *= ((Double)BountyBagsConfig.NETHER_LEGENDARY_MULTIPLIER.get()).doubleValue();
                epic *= ((Double)BountyBagsConfig.NETHER_EPIC_MULTIPLIER.get()).doubleValue();
                superRare *= ((Double)BountyBagsConfig.NETHER_SUPER_RARE_MULTIPLIER.get()).doubleValue();
            }
        }
        double mobMultiplier = EventHandler.getIndividualMobMultiplier(entityTypeString);
        if (mobMultiplier != 1.0) {
            legendary *= mobMultiplier;
            epic *= mobMultiplier;
            superRare *= mobMultiplier;
            rare *= mobMultiplier;
        }
        double legendaryThreshold = legendary;
        double epicThreshold = legendaryThreshold + epic;
        double superRareThreshold = epicThreshold + superRare;
        double rareThreshold = superRareThreshold + rare;
        double rand = Math.random();
        ItemStack lootBag = ItemStack.f_41583_;
        if (rand < legendaryThreshold) {
            lootBag = new ItemStack((ItemLike)ItemRegistry.LEGENDARY_LOOT_BAG.get());
        } else if (rand < epicThreshold) {
            lootBag = new ItemStack((ItemLike)ItemRegistry.EPIC_LOOT_BAG.get());
        } else if (rand < superRareThreshold) {
            lootBag = new ItemStack((ItemLike)ItemRegistry.SUPER_RARE_LOOT_BAG.get());
        } else if (rand < rareThreshold) {
            lootBag = new ItemStack((ItemLike)ItemRegistry.RARE_LOOT_BAG.get());
        }
        if (!lootBag.m_41619_()) {
            entity.m_19983_(lootBag);
        }
    }

    private static double getIndividualMobMultiplier(String entityTypeString) {
        switch (entityTypeString) {
            case "minecraft:zombie": {
                return (Double)BountyBagsConfig.ZOMBIE_DROP_MULTIPLIER.get();
            }
            case "minecraft:skeleton": {
                return (Double)BountyBagsConfig.SKELETON_DROP_MULTIPLIER.get();
            }
            case "minecraft:creeper": {
                return (Double)BountyBagsConfig.CREEPER_DROP_MULTIPLIER.get();
            }
            case "minecraft:spider": 
            case "minecraft:cave_spider": {
                return (Double)BountyBagsConfig.SPIDER_DROP_MULTIPLIER.get();
            }
            case "minecraft:enderman": {
                return (Double)BountyBagsConfig.ENDERMAN_DROP_MULTIPLIER.get();
            }
        }
        return 1.0;
    }
}

