/*
 * Decompiled with CFR 0.152.
 */
package com.example.lootbag;

import com.example.lootbag.BountyBagsConfig;
import com.example.lootbag.ItemRegistry;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class CustomLootGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<ItemStack> generateLoot(Level level, Item bagType) {
        List lootItems;
        int maxItems;
        int minItems;
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        RandomSource random = level.f_46441_;
        if (!((Boolean)BountyBagsConfig.USE_CUSTOM_LOOT.get()).booleanValue()) {
            return loot;
        }
        if (bagType == ItemRegistry.RARE_LOOT_BAG.get()) {
            minItems = (Integer)BountyBagsConfig.RARE_MIN_ITEMS.get();
            maxItems = (Integer)BountyBagsConfig.RARE_MAX_ITEMS.get();
            lootItems = (List)BountyBagsConfig.RARE_LOOT_ITEMS.get();
        } else if (bagType == ItemRegistry.SUPER_RARE_LOOT_BAG.get()) {
            minItems = (Integer)BountyBagsConfig.SUPER_RARE_MIN_ITEMS.get();
            maxItems = (Integer)BountyBagsConfig.SUPER_RARE_MAX_ITEMS.get();
            lootItems = (List)BountyBagsConfig.SUPER_RARE_LOOT_ITEMS.get();
        } else if (bagType == ItemRegistry.EPIC_LOOT_BAG.get()) {
            minItems = (Integer)BountyBagsConfig.EPIC_MIN_ITEMS.get();
            maxItems = (Integer)BountyBagsConfig.EPIC_MAX_ITEMS.get();
            lootItems = (List)BountyBagsConfig.EPIC_LOOT_ITEMS.get();
        } else if (bagType == ItemRegistry.LEGENDARY_LOOT_BAG.get()) {
            minItems = (Integer)BountyBagsConfig.LEGENDARY_MIN_ITEMS.get();
            maxItems = (Integer)BountyBagsConfig.LEGENDARY_MAX_ITEMS.get();
            lootItems = (List)BountyBagsConfig.LEGENDARY_LOOT_ITEMS.get();
        } else {
            return loot;
        }
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        int totalWeight = 0;
        for (String itemString : lootItems) {
            LootEntry entry = LootEntry.fromString(itemString);
            if (entry == null) continue;
            entries.add(entry);
            totalWeight += entry.weight;
        }
        if (entries.isEmpty() || totalWeight == 0) {
            LOGGER.warn("No valid loot entries found for bag type: {}", (Object)bagType);
            return loot;
        }
        int itemCount = minItems + random.m_188503_(maxItems - minItems + 1);
        block1: for (int i = 0; i < itemCount; ++i) {
            int randomWeight = random.m_188503_(totalWeight);
            int currentWeight = 0;
            for (LootEntry entry : entries) {
                if (randomWeight >= (currentWeight += entry.weight)) continue;
                ItemStack item = CustomLootGenerator.createItemStack(entry, random);
                if (item.m_41619_()) continue block1;
                loot.add(item);
                continue block1;
            }
        }
        return loot;
    }

    private static ItemStack createItemStack(LootEntry entry, RandomSource random) {
        try {
            ResourceLocation itemId = new ResourceLocation(entry.itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                LOGGER.warn("Unknown item: {}", (Object)entry.itemId);
                return ItemStack.f_41583_;
            }
            ItemStack stack = new ItemStack((ItemLike)item, entry.count);
            if (entry.enchanted && stack.m_41792_()) {
                int enchantLevel = 15 + random.m_188503_(16);
                EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)stack, (int)enchantLevel, (boolean)true);
            }
            return stack;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create item stack for: {}. Error: {}", (Object)entry.itemId, (Object)e.getMessage());
            return ItemStack.f_41583_;
        }
    }

    public static class LootEntry {
        public final String itemId;
        public final int count;
        public final int weight;
        public final boolean enchanted;

        public LootEntry(String itemId, int count, int weight, boolean enchanted) {
            this.itemId = itemId;
            this.count = count;
            this.weight = weight;
            this.enchanted = enchanted;
        }

        public static LootEntry fromString(String entry) {
            try {
                String[] parts = entry.split(":");
                if (parts.length < 3) {
                    LOGGER.warn("Invalid loot entry format: {}. Expected format: 'item_id:count:weight' or 'item_id:count:weight:enchanted'", (Object)entry);
                    return null;
                }
                String itemId = parts[0] + ":" + parts[1];
                int count = Integer.parseInt(parts[2]);
                int weight = Integer.parseInt(parts[3]);
                boolean enchanted = parts.length > 4 && "enchanted".equalsIgnoreCase(parts[4]);
                return new LootEntry(itemId, count, weight, enchanted);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse loot entry: {}. Error: {}", (Object)entry, (Object)e.getMessage());
                return null;
            }
        }
    }
}

